% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.delta.all.enz.R
\name{RNV.delta.all.enz}
\alias{RNV.delta.all.enz}
\title{Delta at RNV for all enzymes}
\usage{
RNV.delta.all.enz(E_res_fun,A_fun,N_fun,correl_fun,beta_fun=NULL,tol_fun=0.0001)
}
\arguments{
\item{E_res_fun}{Numeric vector of enzyme concentrations (resident)}

\item{A_fun}{Numeric vector of activities}

\item{N_fun}{Numeric. Population size}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{tol_fun}{Numeric and positive value. Accuracy for delta bounds. Default is \code{0.0001}}
}
\value{
List of \emph{n} elements, one for each enzyme \emph{i} considering that \eqn{i} is targeted by the mutation.

For each element of the list, we have a vector of length 2 or 4, depending on applied constraint \code{correl_fun}. Values of this vector are:
\enumerate{
   \item \emph{delta_i} value for inferior bounds of the near RNV
   \item \emph{delta_i} value for superior bounds of the near RNV
   \item \emph{delta_i} value for inferior bounds of the far RNV (if exists)
   \item \emph{delta_i} value for superior bounds of the far RNV (if exists)
}

If superior bound is not accessible, value is \code{NA}.

Note that \code{n} is the number of enzymes, which is the length of \code{E_ini_fun}.
}
\description{
This function computes actual mutation effect \eqn{\delta} at RNV for each enzyme
}
\details{
The \emph{Range of Neutral Variations} (RNV) are mutant concentration values such as coefficient selection is between \eqn{1/(2N)} and \eqn{-1/(2N)}.

Inferior (resp. superior) bound of RNV corresponds to selection coefficient equal to \eqn{-1/(2N)} (resp. \eqn{1/(2N)}).

Function \code{RNV.delta.all.enz} computes the actual mutation effect \eqn{delta_i} at RNV bounds, where \eqn{i} is the enzyme targeted by the mutation.


Depending on applied constraints \code{correl_fun}, it exists 1 or 2 RNV.
In case of independence (\code{"SC"}) or positive regulation between all enzymes (\code{"RegPos"}), flux has no limit and there is only one RNV.
In other cases (competition and/or negative regulation), because flux can reach a maximum, there is two RNV:
a "near" one, for small mutations, and a "far" one for big mutations that put mutants in the other side of flux dome.


\bold{Known bug}

Due to use of \code{\link{range_delta}} to limit search area, output \eqn{\delta} is computed to have mutant concentration between 0 and \code{sum(E_res_fun)} (resident total concentration).
If \eqn{\delta} is too high (mutant concentration over resident total concentration), output \eqn{\delta} could be \code{NA} rather than a numeric value. This case might happen when \code{N_fun} is too low and \code{correl_fun="SC"} or \code{"RegPos"} (no limit on total concentration),
}
\examples{
Er <- c(30,30,30)
A <- c(1,10,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "CRPos"
N <- 1000

RNV.delta.all.enz(Er,A,N,correl,beta)

correl <- "SC"
RNV.delta.all.enz(Er,A,N,correl)



}
\references{
Coton et al. (2021)
}
\seealso{
\eqn{delta} at RNV bounds is obtained by nullify the expression in \code{\link{odd.discrete.sel.coef}}.
}
