% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.compute.elements.R
\name{RNV.compute.elements}
\alias{RNV.compute.elements}
\title{Compute RNV and associated elements for all enzymes \emph{(Deprecated)}}
\usage{
RNV.compute.elements(mat_E,mat_A,N_fun,correl_fun,beta_fun=NULL,
end.mean=TRUE,add.RNV.J=FALSE,mat_J=NULL,X_fun=1)
}
\arguments{
\item{mat_E}{Numeric matrix of concentrations. Columns correspond to enzyme number, and rows correspond to different resident.}

\item{mat_A}{Numeric matrix of activities. Same dimensions as \code{mat_E}.}

\item{N_fun}{Numeric. Population size}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{end.mean}{Logical. If \code{FALSE}, compute RNV size mean of all resident. If \code{TRUE}, compute RNV size mean for last half of resident only.}

\item{add.RNV.J}{Logical. Add value of flux at RNV ? If \code{TRUE}, possibility set also \code{mat_J}.}

\item{mat_J}{Numeric matrix of flux. One column and same rows number as \code{mat_E}. Optional.}

\item{X_fun}{Numeric value. Default is \code{1}}
}
\value{
List of 7 elements:
\itemize{
   \item \code{$RNV_delta} : list of \code{n} elements, one by enzyme.
   Each element contains a numeric matrix of \code{nb_resid} rows and two or four columns.
   For each enzyme \eqn{i} (a list element), each row corresponds to one resident and columns are actual mutation effect \eqn{\delta_i} corresponding respectively to inferior bound (col 1) and superior bound (col 2) of RNV (x2 if there is a second RNV).
   Each row is a result of \code{\link{RNV.delta.all.enz}}.
   \item \code{$RNV_enz} : same structure as \code{$RNV_delta}, but for mutant enzyme concentrations at RNV limits, \emph{i.e.} \eqn{E_i + \delta_i} for each target enzyme \eqn{i} ;
   \item \code{$RNV_size} : list of one or two elements (depending on RNV number).
   Each element contains a matrix of \code{n} columns (one by enzyme) and \code{nb_resid} rows.
   Each cell is the RNV size for current enzyme (in column) and current resident (in row).
   The RNV size is absolute value of \eqn{\delta_i^sup} minus \eqn{\delta_i^inf}. If there is no superior bounds but there is two RNV, RNV size is obtained by the difference of the two \eqn{\delta_i^inf}.
   \item \code{$RNV_size_divEtot} : same structure as \code{$RNV_size}, but for RNV size divided by total concentration of corresponding resident.
   \item \code{$RNV_proxy} : numeric matrix of one or two rows (depending on RNV number) and \code{n} columns (one by enzyme).
   Each cell id the mean of RNV size. If \code{end.mean=TRUE}, the mean is computed from last half of resident.
   \item \code{$RNV_proxy_divEtot} : same structure as \code{$RNV_proxy}, but mean of RNV size is divided by mean of total concentration.
   \item \code{$RNV_flux} : numeric matrix of two columns (inferior and superior limits of neutral zone) and \code{nb_resid} rows.
   Each cell is the flux value at neutral zone limits.
}



Note that \code{n} is the number of enzymes. \code{nb_resid} is the number of resident and s also the row number of \code{mat_E} and \code{mat_A}.
}
\description{
\emph{(Deprecated)}. This function computes different elements at RNV, for different resident concentrations, based on function \code{\link{RNV.delta.all.enz}}
For simulations, preferably use \code{\link{RNV.for.simul}}.
}
\details{
The \emph{Range of Neutral Variations} (RNV) are mutant concentration values such as coefficient selection is between \eqn{1/(2N)} and \emph{-1/(2N)}.

Inferior (resp. superior) bound of RNV corresponds to selection coefficient equal to \eqn{-1/(2N)} (resp. \eqn{1/(2N)}).


Function \code{RNV.compute.elements} computes the \eqn{\delta_i} at RNV bounds (where \eqn{i} is the enzyme targeted by the mutation),
but also mutant concentrations at RNV bounds and the RNV size.

The RNV size is the absolute value of \eqn{\delta_i^sup} minus \eqn{\delta_i^inf}.
 
Depending on applied constraint \code{correl_fun}, it exists 1 or 2 RNV.
In case of independence (\code{"SC"}) or positive regulation between all enzymes (\code{"RegPos"}), flux has no limit and there is only one RNV.
In other cases (competition and/or negative regulation), because flux can reach a maximum, there is two RNVs:
 a "near" one, for small mutations, and a "far" one for big mutations that put mutant in the other side of flux dome.

This function \code{RNV.compute.elements} is designed to compute RNV of \emph{one} simulation launched by \code{\link{simul.evol.enz.multiple}}.
For example, for simulation 1, put \code{mat_E=tabR[tabR$sim==1,1:n]} and \code{mat_A=tabR[tabR$sim==1,(2*n+4):(3*n+3)]}. To reduce computation time, put \code{mat_J=tabR[tabR$sim==1,(2*n+3)]} for flux.
It also works for different resident values of concentrations and activities.
}
\examples{
\donttest{
#for 2 resident genotypes and 3 enzymes
Er <- matrix(30,ncol=3,nrow=2)
A <- matrix(c(1,10,30),byrow=TRUE,ncol=3,nrow=2)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- compute.B.from.beta(beta)
correl <- "CRPos"
N <- 1000

#second resident = theoretical equilibrium of first resident
Er[2,] <- 100*predict_th(A[1,],correl,B)$pred_e

RNV.compute.elements(Er,A,N,correl,beta,add.RNV.J=TRUE)
}



}
\seealso{
See function \code{\link{RNV.delta.all.enz}} to see how actual mutation effect \eqn{\delta} is computed. 

For simulations, preferably use \code{\link{RNV.for.simul}}. Code is almost the same for the two functions, but differs in input.
}
