% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut.E.old.R
\name{mut.E.old}
\alias{mut.E.old}
\title{Old method for mutation of enzyme concentrations}
\usage{
mut.E.old(E_fun,i_fun,nu_fun,correl_fun,beta_fun=NULL,typ_E=1)
}
\arguments{
\item{E_fun}{Numeric vector of enzyme concentrations (resident)}

\item{i_fun}{Numeric value corresponding to number of the enzyme targeted by the mutation}

\item{nu_fun}{Numeric value of \bold{canonical} mutation effect}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{typ_E}{Numeric for mutation method. Authorized values: 1 or 2. Default is 1.}
}
\value{
Numeric vector corresponding to mutant value of enzyme concentrations
}
\description{
Computes the mutant value of enzyme concentrations with the old method (see Lion \emph{et al.} 2004).
}
\details{
This mutation method is named \emph{old}, because it was used the first one used for evolution simulation.
Some improvements has been made since.

The main difference with mutation function \code{\link{mut.E.direct}} is the method to compute mutant values under competition constraint.
 In this function \code{mut.E.old}, canonical effect \eqn{\nu} is redistributed only on enzymes different from the target one,
 whereas in \code{mut.E.direct}, mutation canonical effect is redistributed between \bold{all} enzymes, including the target one.

Moreover, computation method in \code{mut.E.direct} is simplified.

Last, this \emph{old} method includes two model of mutations: additive and multiplicative.

\itemize{
   \item Additive method (\code{typ_E=1}): mutant concentration is the sum of the resident one plus size of mutation \eqn{\nu}
   \item Multiplicative method (\code{typ_E=2}): mutant concentration is the product of the resident one and \eqn{1+\nu}
   }
   Default is method 1.
   
In \code{mut.E.direct}, only method 1 is kept.
}
\examples{
E <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "RegPos"
mu <- 1 #canonical size of mutation
i <- 3 #enzyme directly targeted by mutation

mut.E.old(E,i,mu,correl,beta)

}
\references{
Lion, S., F. Gabriel, B. Bost, J. Fiévet, C. Dillmann, and D. De Vienne, 2004. An extension to the metabolic control theory taking into account correlations between enzyme concentrations. European Journal of Biochemistry 271:4375–4391.
}
\seealso{
See function \code{\link{mut.E.direct}} for a direct computation method of mutation.
}
