% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RD}
\alias{RD}
\title{Compute the relative difference}
\usage{
RD(est, pop, as.vector = TRUE, unname = FALSE)
}
\arguments{
\item{est}{a \code{numeric} vector or matrix containing the parameter estimates}

\item{pop}{a \code{numeric} vector or matrix containing the true parameter values. Must be
of the same dimensions as \code{est}}

\item{as.vector}{logical; always wrap the result in a \code{\link{as.vector}} function
before returning?}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\value{
returns a \code{vector} or \code{matrix} depending on the inputs and whether
  \code{as.vector} was used
}
\description{
Computes the relative difference statistic of the form \code{(est - pop)/ pop}, which
is equivalent to the form \code{est/pop - 1}. If matrices are supplied then
an equivalent matrix variant will be used of the form
\code{(est - pop) * solve(pop)}. Values closer to 0 indicate better
relative parameter recovery. Note that for single variable inputs this is equivalent to
\code{bias(..., type = 'relative')}.
}
\examples{

# vector
pop <- seq(1, 100, length.out=9)
est1 <- pop + rnorm(9, 0, .2)
(rds <- RD(est1, pop))
summary(rds)

# matrix
pop <- matrix(c(1:8, 10), 3, 3)
est2 <- pop + rnorm(9, 0, .2)
RD(est2, pop, as.vector = FALSE)
(rds <- RD(est2, pop))
summary(rds)


}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
