## Mon Jan 31 02:27:49 2011
## BOUKHETALA Kamal , GUIDOUM Arsalane.
## USTHB, Maths-PS
## Simulation Brownian trajectory in 3D (O,X,Y,Z) 


N=1000;t0=0;T=1;Dt=0.001;X0=0.5;Y0=0.5;Z0=0.5;
drifx     <- expression( 0 )
drify     <- expression( 0 )
drifz     <- expression( 0 )
diff      <- expression( 0.2 ) 

Ax    <- function(t,x,y,z)  eval(drifx)
Ay    <- function(t,x,y,z)  eval(drify)
Az    <- function(t,x,y,z)  eval(drifz)
S     <- function(t,x,y,z)  eval(diff)

if(missing(Dt)){t <- seq (t0 ,T, length =N+1)} else {t <- c(t0 ,t0+ cumsum(rep(Dt,N)))
                T <- t[N +1]}
Dt= (T-t0)/N 
ux = runif(N,0,1)
ox = rep(1,N)
ox [ which(ux < 0.5) ] = -1
wx = cumsum(c(0,ox))*sqrt((T-t0)/N)
Dx    <- diff(wx)

uy = runif(N,0,1)
oy = rep(1,N)
oy [ which(uy < 0.5) ] = -1
wy = cumsum(c(0,oy))*sqrt((T-t0)/N)
Dy    <- diff(wy)

uz = runif(N,0,1)
oz = rep(1,N)
oz [ which(uz < 0.5) ] = -1
wz = cumsum(c(0,oz))*sqrt((T-t0)/N)
Dz    <- diff(wz)

X    <- numeric()
Y    <- numeric()
Z    <- numeric()
X[1] <- X0
Y[1] <- Y0
Z[1] <- Z0
for (i in 2:(N+1)){     
        X[i] = X[i-1] + Ax(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dt + S(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dx[i-1]
        Y[i] = Y[i-1] + Ay(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dt + S(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dy[i-1]
        Z[i] = Z[i-1] + Az(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dt + S(t[i-1],X[i-1],Y[i-1],Z[i-1])*Dz[i-1]
                   } 
G <- data.frame(X,Y,Z)
V = 1
a <- c(0,V,0,0)
b <- c(0,0,V,0)
c <- c(0,0,0,V)
labels <- c("Origin", "X", "Y", "Z")
i <- c(1,2,1,3,1,4)
open3d()
segments3d(a[i],b[i],c[i],color = c("black"),lwd= 2.0)
text3d(a,b,c,labels,adj=0.5,col="red",cex=1.2,family=c("serif"))
text3d(X0,Y0,Z0,c("(X0,Y0,Z0)"),adj=c(0.5,-0.25),cex=1.2,family=c("serif"))
points3d(G[1,],color = c("blue"),size=6)
title3d(family=c("serif"),main="Simulation Three-Dimensional for Brownian Motion",color = c("black"),cex=1.2)
for (i in 1:N) {lines3d(c(G[i,1],G[i+1,1]),c(G[i,2],G[i+1,2]),c(G[i,3],G[i+1,3]),col="red",from ="lines",lwd=2)}
title3d(family=c("serif"),font=4,sub='USTHB,Faculty of Mathematics,Department of Probabilities and Statistics,Algeria Mon Jan 31 02:27:49 2011',color = c("blue"),cex=0.8)


