% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/motifs.R
\name{AddMotifs}
\alias{AddMotifs}
\alias{AddMotifs.default}
\alias{AddMotifs.ChromatinAssay}
\alias{AddMotifs.Assay}
\alias{AddMotifs.Seurat}
\title{Add DNA sequence motif information}
\usage{
AddMotifs(object, ...)

\method{AddMotifs}{default}(object, genome, pfm, verbose = TRUE, ...)

\method{AddMotifs}{ChromatinAssay}(object, genome, pfm, verbose = TRUE, ...)

\method{AddMotifs}{Assay}(object, genome, pfm, verbose = TRUE, ...)

\method{AddMotifs}{Seurat}(object, genome, pfm, assay = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object or ChromatinAssay object}

\item{...}{Additional arguments passed to other methods}

\item{genome}{A \code{BSgenome}, \code{DNAStringSet}, \code{FaFile}, or
string stating the genome build recognized by \code{getBSgenome}.}

\item{pfm}{A \code{PFMatrixList} or \code{PWMatrixList} object containing
position weight/frequency matrices to use}

\item{verbose}{Display messages}

\item{assay}{Name of assay to use. If NULL, use the default assay}
}
\value{
When running on a \code{ChromatinAssay} or \code{Seurat} object,
returns a modified version of the input object. When running on a matrix,
returns a \code{Motif} object.
}
\description{
Construct a \code{\link{Motif}} object containing DNA sequence motif
information and add it to an existing Seurat object or ChromatinAssay.
If running on a Seurat object, \code{AddMotifs} will also run
\code{\link{RegionStats}} to compute the GC content of each peak and store
the results in the feature metadata. PFMs or PWMs are matched to the genome
sequence using the \code{\link[motifmatchr]{matchMotifs}} function with
default parameters to construct a matrix of motif positions in genomic
regions.
}
\seealso{
\pkg{motifmatchr}
}
\concept{motifs}
