% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{CutMatrix}
\alias{CutMatrix}
\title{Generate matrix of integration sites}
\usage{
CutMatrix(
  object,
  region,
  tabix.file = NULL,
  assay = NULL,
  cells = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object}

\item{region}{A GRanges object containing the region of interest}

\item{tabix.file}{A TabixFile object. If NULL, the file specified in \code{fragment.path}
will be opened and closed after the function completes. If iterating over many regions, providing an
open TabixFile is much faster as it avoids opening and closing the connection each time.}

\item{assay}{Name of the assay to use}

\item{cells}{Which cells to include in the matrix. If NULL (default), use all
cells in the object}

\item{verbose}{Display messages}
}
\value{
Returns a sparse matrix
}
\description{
Generates a cell-by-position matrix of Tn5 integration sites
centered on a given region (usually a DNA sequence motif). This
matrix can be used for downstream footprinting analysis.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
atac_small <- SetFragments(atac_small, file = fpath)
CutMatrix(
 object = atac_small,
 region = StringToGRanges("chr1-10245-762629")
)
}
