% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.net.R
\name{write.net}
\alias{write.net}
\title{Write a Network in Parenthetic Format}
\usage{
write.net(
  net,
  file = "",
  append = FALSE,
  digits = 10,
  tree.names = FALSE,
  tol = 1e-08,
  swap.minor = TRUE
)
}
\arguments{
\item{net}{A phylogenetic network of class \code{evonet}. The network may include an optional attribute `inheritance`` that represents the inheritance probabilities on the edges found in the 'reticulation' attribute}

\item{file}{a file name specified by either a variable of mode character, or a double-quoted string; if `file = ""`` (the default) then the tree is written on the standard output connection (i.e. the console).}

\item{append}{a logical, if TRUE the tree is appended to the file without erasing the data possibly existing in the file, otherwise the file (if it exists) is overwritten (`FALSE`` the default).}

\item{digits}{a numeric giving the number of digits used for printing branch lengths.}

\item{tree.names}{either a logical or a vector of mode character. If TRUE then any tree names will be written prior to the tree on each line. If character, specifies the name of "phylo" objects which can be written to the file.}

\item{tol}{a numeric value giving the tolerance to consider a branch as length 0.}

\item{swap.minor}{a logical, TRUE swaps hybrid edges around such that edges with inheritance <0.5 are always written as leaves}
}
\value{
a vector of mode character if file = "", none (invisible NULL) otherwise
}
\description{
This function writes a network to file in the Extended Newick format.
}
\details{
The node labels and the root edge length, if available, are written in the file.

If inheritance probabilities are included in the network object as the 'inheritance' attribute, they are also written to file.

If tree.names == TRUE then a variant of the Newick format is written for which the name of a tree precedes the Newick format tree (parentheses are eventually deleted beforehand). The tree names are taken from the names attribute if present (they are ignored if tree.names is a character vector).

The tip labels (and the node labels if present) are checked before being printed: the leading and trailing spaces, and the leading left and trailing right parentheses are deleted; the other spaces are replaced by underscores; the commas, colons, semicolons, and the other parentheses are replaced with dashes
}
\examples{
net<-read.net(text="((A:7,((B:2,C:2):3)#H1:2::0.6):3,(D:6,#H1:1::0.4):4);")
write.net(net)

}
