% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv.R
\name{ivreg_ss}
\alias{ivreg_ss}
\title{Inference in an IV regression with a shift-share instrument}
\usage{
ivreg_ss(
  formula,
  X,
  data,
  W,
  subset,
  weights,
  method,
  beta0 = 0,
  alpha = 0.05,
  region_cvar = NULL,
  sector_cvar = NULL
)
}
\arguments{
\item{formula}{An object of class \code{"formula"} (or one that can be
coerced to that class) of the form \code{outcome ~ controls |
endogenous_regressor}. For a regression with no controls (only an
intercept), it takes the form \code{outcome ~ 1 | endogenous_regressor}}

\item{X}{Shift-share vector with length \code{N} of sectoral shocks,
aggregated to regional level using the share matrix \code{W}. That is,
each element of \code{X} corresponds to a region.}

\item{data}{An optional data frame, list or environment (or object coercible
by \code{as.data.frame} to a data frame) containing the outcome and
running variables in the model. If not found in \code{data}, the
variables are taken from \code{environment(formula)}, typically the
environment from which the function is called. Each row in the data frame
corresponds to a region.}

\item{W}{A matrix of sector shares, so that \code{W[i, s]} corresponds to
share of sector \code{s} in region \code{i}. The ordering of the regions
must coincide with that in the other inputs, such as \code{X}. The
ordering of the sectors in the columns of \code{W} is irrelevant but the
identity of the sectors in must coincide with those used to construct
\code{X}.}

\item{subset}{An optional vector specifying a subset of observations to be
used in the fitting process.}

\item{weights}{An optional vector of weights to be used in the fitting
process. Should be \code{NULL} or a numeric vector, with each row
corresponding to a region. If non-\code{NULL}, for computing the first
stage and the reduced form, weighted least squares is used with weights
\code{weights} (that is, we minimize \code{sum(weights*residuals^2)});
otherwise ordinary least squares is used.}

\item{method}{Vector specifying which inference methods to use. The vector
    elements have to be one or more of the following strings:

\describe{

\item{\code{"homosk"}}{Assume i.i.d. homoskedastic errors}

\item{\code{"ehw"}}{Eicker-Huber-White standard errors}

\item{\code{"region_cluster"}}{Standard errors clustered at regional level}

\item{\code{"akm"}}{Adão-Kolesár-Morales}

\item{\code{"akm0"}}{Adão-Kolesár-Morales with null imposed. Note the
reported standard error for this method corresponds to the normalized
standard error, given by the length of the confidence interval divided by
\eqn{2z_{1-\alpha/2}}{2z_{1-alpha/2}}}

\item{\code{"all"}}{All of the methods above}}}

\item{beta0}{null that is tested (only affects reported p-values)}

\item{alpha}{Determines confidence level of reported confidence intervals,
which will have coverage \code{1-alpha}.}

\item{region_cvar}{A vector with length \code{N} of cluster variables, for
method \code{"cluster_region"}. If the vector \code{1:N} is used,
clustering is effectively equivalent to \code{ehw}}

\item{sector_cvar}{A vector with length \code{S} of cluster variables, if
sectors are to be clustered, for methods \code{"akm"} and \code{"akm0"}.
If the vector \code{1:S} is used, this is equivalent to not clustering.}
}
\value{
Returns an object of class \code{"SSResults"} containing the
    estimation and inference results. The \code{print} function can be used
    to print a summary of the results. The object is a list with at least the
    following components: \describe{

\item{beta}{Point estimate of the effect of interest \eqn{\beta}{beta}}

\item{se, p}{A vector of standard errors and a vector of p-values of the null
\eqn{H_{0}\colon \beta = \beta_{0}}{H_0 : beta = beta0} for the inference
methods in \code{method}, with \eqn{\beta_{0}}{beta0} specified by the
argument \code{beta0}. For the method \code{"akm0"}, the standard error
corresponds to the effective standard error (length of the confidence
interval divided by \code{2*stats::qnorm(1-alpha/2)})}

\item{ci.l, ci.r}{Upper and lower endpoints of the confidence interval for
the effect of interest \eqn{\beta}{beta}, for each of the methods in
\code{method}}

}
}
\description{
Computes confidence intervals and p-values in an instrumental variables
regression in which the instrument has a shift-share structure, as in Bartik
(1991). Several different inference methods can computed, as specified by
\code{method}.
}
\section{Note}{
 \code{subset} is evaluated in the same way as variables in
    \code{formula}, that is first in \code{data} and then in the environment
    of \code{formula}.
}

\examples{
## Use ADH data from Autor, Dorn, and Hanson (2013)
ivreg_ss(d_sh_empl ~ 1 | shock, X=IV, data=ADH$reg, W=ADH$W,
         method=c("ehw", "akm", "akm0"))
}
\references{
{

\cite{Bartik, Timothy J., Who Benefits from State and Local Economic
Development Policies?, Kalamazoo, MI: W.E. Upjohn Institute for Employment
Research, 1991.}

\cite{Adão, Rodrigo, Kolesár, Michal, and Morales, Eduardo,
"Shift-Share Designs: Theory and Inference", Quarterly Journal of Economics
2019, 134 (4), 1949-2010.}

}
}
