% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sherlock.R
\name{Sherlock}
\alias{Sherlock}
\title{Sherlock}
\usage{
Sherlock(
  titles = "NONE",
  texts,
  patterns,
  toupper,
  odir,
  concord = FALSE,
  minl = 100,
  P = 1e-05,
  verbose = FALSE
)
}
\arguments{
\item{titles}{is a character string containing the full path name
for a text file containing the titles of the stories
in the same order that they appear in the texts file.
If titles=="NONE", treat the entire book as one story.}

\item{texts}{is a character string containing the full path name for a text file containing the full texts of all of the stories}

\item{patterns}{is a vector containing the search patterns}

\item{toupper}{is a Boolean TRUE if the titles should be converted to upper case}

\item{odir}{is a character string containing the full path name of the output directory}

\item{concord}{Boolean if TRUE invoke concordance()}

\item{minl}{is an integer param passed to dpseg::dpseg}

\item{P}{is a numeric param passed to dpseg::dpseg}

\item{verbose}{Boolean if TRUE print informative or diagnostic messages to console}
}
\value{
returns no value but has side effect of driving the concordance computations
}
\description{
This function is the driver that organizes
the computation of concordances in Sherlock Holmes stories
}
\examples{
titles<-system.file("extdata/contents3.txt",package="SherlockHolmes")
texts<-system.file("extdata/processed_download3.txt",package="SherlockHolmes")
SH<-Sherlock(titles=titles,texts=texts,patterns=patterns[1],
 toupper=TRUE,odir=tempdir(),concord=FALSE,minl=100,P=0.00001,
 verbose=FALSE)
 

}
