% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroids.R
\name{Centroids-methods}
\alias{Centroids-methods}
\alias{Cells.Centroids}
\alias{GetTissueCoordinates.Centroids}
\alias{Radius.Centroids}
\alias{RenameCells.Centroids}
\alias{Theta.Centroids}
\alias{is.finite.Centroids}
\alias{is.infinite.Centroids}
\alias{length.Centroids}
\alias{lengths.Centroids}
\alias{subset.Centroids}
\alias{[,Centroids,character,ANY,ANY-method}
\alias{[,Centroids,numeric,ANY,ANY-method}
\alias{show,Centroids-method}
\title{\code{Centroids} Methods}
\usage{
\method{Cells}{Centroids}(x, ...)

\method{GetTissueCoordinates}{Centroids}(object, full = TRUE, ...)

\method{Radius}{Centroids}(object, ...)

\method{RenameCells}{Centroids}(object, new.names = NULL, ...)

\method{Theta}{Centroids}(object)

\method{is.finite}{Centroids}(x)

\method{is.infinite}{Centroids}(...)

\method{length}{Centroids}(x)

\method{lengths}{Centroids}(x, use.names = TRUE)

\method{subset}{Centroids}(x, cells = NULL, ...)

\S4method{[}{Centroids,character,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Centroids,numeric,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{show}{Centroids}(object)
}
\arguments{
\item{x, object}{A \code{\link[SeuratObject:Centroids-class]{Centroids}}
object}

\item{...}{Arguments passed to other methods}

\item{full}{Expand the coordinates to the full polygon}

\item{new.names}{vector of new cell names}

\item{use.names}{Ignored}

\item{i, cells}{A vector of cells to keep; if \code{NULL}, defaults
to all cells}

\item{j, drop}{Ignored}
}
\value{
\code{GetTissueCoordinates}: A data frame with three columns:
\itemize{
 \item \dQuote{\code{x}}: the x-coordinate
 \item \dQuote{\code{y}}: the y-coordinate
 \item \dQuote{\code{cell}}: the cell name
}
If \code{full} is \code{TRUE}, then each coordinate will indicate a vertex
for the cell polygon; otherwise, each coordinate will indicate a centroid
for the cell

\code{Radius} The radius of the centroids

\code{RenameCells}: \code{object} with the cells renamed to
\code{new.names}

\code{Theta}: The offset angle in degrees

\code{is.finite}: \code{TRUE} if the centroids are polygonal,
\code{FALSE} if circular

\code{is.infinite}: The opposite of \code{is.finite}

\code{length}: \code{0} if the centroids are circular, otherwise the
number of sides of the polygonal centroid

\code{lengths}: An \code{\link[base:rle]{rle}} object for the cells

\code{subset}, \code{[}: \code{x} subsetted to the cells specified
by \code{cells}/\code{i}

\code{show}: Invisibly returns \code{NULL}
}
\description{
Methods for \code{\link[SeuratObject:Centroids-class]{Centroids}} objects
}
\details{
\code{GetTissueCoordinates}: Get cell spatial coordinates

\code{Radius}: Get the centroid radius

\code{RenameCells}: Update cell names

\code{Theta}: Get the offset angle

\code{is.finite}, \code{is.infinite}: Test to see if the centroids
are circular or polygonal

\code{length}: Get the number of sides for the polygonal centroid

\code{lengths}: Generate a run-length encoding of the cells present

\code{subset}, \code{[}: Subset a \code{Centroids} object to
certain cells

\code{show}: Display an object summary to stdout
}
\seealso{
\code{\link{Centroids-class}}

Segmentation layer classes:
\code{\link{Centroids-class}},
\code{\link{Molecules-class}},
\code{\link{Molecules-methods}},
\code{\link{Segmentation-class}},
\code{\link{Segmentation-methods}}
}
\concept{segmentation}
