% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{FilterSlideSeq}
\alias{FilterSlideSeq}
\title{Filter stray beads from Slide-seq puck}
\usage{
FilterSlideSeq(
  object,
  image = "image",
  center = NULL,
  radius = NULL,
  do.plot = TRUE
)
}
\arguments{
\item{object}{Seurat object with slide-seq data}

\item{image}{Name of the image where the coordinates are stored}

\item{center}{Vector specifying the x and y coordinates for the center of the
inclusion circle}

\item{radius}{Radius of the circle of inclusion}

\item{do.plot}{Display a \code{\link{SpatialDimPlot}} with the cells being
removed labeled.}
}
\value{
Returns a Seurat object with only the subset of cells that pass the
circular filter
}
\description{
This function is useful for removing stray beads that fall outside the main
Slide-seq puck area. Essentially, it's a circular filter where you set a
center and radius defining a circle of beads to keep. If the center is not
set, it will be estimated from the bead coordinates (removing the 1st and
99th quantile to avoid skewing the center by the stray beads). By default,
this function will display a \code{\link{SpatialDimPlot}} showing which cells
were removed for easy adjustment of the center and/or radius.
}
\examples{
\dontrun{
# This example uses the ssHippo dataset which you can download
# using the SeuratData package.
library(SeuratData)
data('ssHippo')
# perform filtering of beads
ssHippo.filtered <- FilterSlideSeq(ssHippo, radius = 2300)
# This radius looks to small so increase and repeat until satisfied
}
}
\concept{objects}
\concept{spatial}
