% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FastRPCAIntegration}
\alias{FastRPCAIntegration}
\title{Perform integration on the joint PCA cell embeddings.}
\usage{
FastRPCAIntegration(
  object.list,
  reference = NULL,
  anchor.features = 2000,
  k.anchor = 20,
  dims = 1:30,
  scale = TRUE,
  normalization.method = c("LogNormalize", "SCT"),
  new.reduction.name = "integrated_dr",
  npcs = 50,
  findintegrationanchors.args = list(),
  verbose = TRUE
)
}
\arguments{
\item{object.list}{A list of \code{\link{Seurat}} objects between which to
find anchors for downstream integration.}

\item{reference}{A vector specifying the object/s to be used as a reference
during integration. If NULL (default), all pairwise anchors are found (no
reference/s). If not NULL, the corresponding objects in \code{object.list}
will be used as references. When using a set of specified references, anchors
are first found between each query and each reference. The references are
then integrated through pairwise integration. Each query is then mapped to
the integrated reference.}

\item{anchor.features}{Can be either:
\itemize{
  \item{A numeric value. This will call \code{\link{SelectIntegrationFeatures}}
  to select the provided number of features to be used in anchor finding}
  \item{A vector of features to be used as input to the anchor finding process}
}}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{dims}{Which dimensions to use from the CCA to specify the neighbor
search space}

\item{scale}{Whether or not to scale the features provided. Only set to FALSE
if you have previously scaled the features you want to use for each object in
the object.list}

\item{normalization.method}{Name of normalization method used: LogNormalize
or SCT}

\item{new.reduction.name}{Name of integrated dimensional reduction}

\item{npcs}{Total Number of PCs to compute and store (50 by default)}

\item{findintegrationanchors.args}{A named list of additional arguments to
\code{\link{FindIntegrationAnchors}}}

\item{verbose}{Print messages and progress}
}
\value{
Returns a Seurat object with integrated dimensional reduction
}
\description{
This is a convenience wrapper function around the following three functions
that are often run together when perform integration.
#' \code{\link{FindIntegrationAnchors}}, \code{\link{RunPCA}},
\code{\link{IntegrateEmbeddings}}.
}
\concept{integration}
