% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{BuildClusterTree}
\alias{BuildClusterTree}
\title{Phylogenetic Analysis of Identity Classes}
\usage{
BuildClusterTree(
  object,
  assay = NULL,
  features = NULL,
  dims = NULL,
  graph = NULL,
  slot = "data",
  reorder = FALSE,
  reorder.numeric = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{assay}{Assay to use for the analysis.}

\item{features}{Genes to use for the analysis. Default is the set of
variable genes (\code{VariableFeatures(object = object)})}

\item{dims}{If set, tree is calculated in PCA space; overrides \code{features}}

\item{graph}{If graph is passed, build tree based on graph connectivity between
clusters; overrides \code{dims} and \code{features}}

\item{slot}{Slot to use; will be overriden by \code{use.scale} and \code{use.counts}}

\item{reorder}{Re-order identity classes (factor ordering), according to
position on the tree. This groups similar classes together which can be
helpful, for example, when drawing violin plots.}

\item{reorder.numeric}{Re-order identity classes according to position on
the tree, assigning a numeric value ('1' is the leftmost node)}

\item{verbose}{Show progress updates}
}
\value{
A Seurat object where the cluster tree can be accessed with \code{\link{Tool}}
}
\description{
Constructs a phylogenetic tree relating the 'average' cell from each
identity class. Tree is estimated based on a distance matrix constructed in
either gene expression space or PCA space.
}
\details{
Note that the tree is calculated for an 'average' cell, so gene expression
or PC scores are averaged across all cells in an identity class before the
tree is constructed.
}
\examples{
pbmc_small
pbmc_small <- BuildClusterTree(object = pbmc_small)
Tool(object = pbmc_small, slot = 'BuildClusterTree')

}
