% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunPCA}
\alias{RunPCA}
\title{Run Principal Component Analysis on gene expression using IRLBA}
\usage{
RunPCA(object, pc.genes = NULL, pcs.compute = 20, use.imputed = FALSE,
  rev.pca = FALSE, weight.by.var = TRUE, do.print = TRUE,
  pcs.print = 1:5, genes.print = 30, reduction.name = "pca",
  reduction.key = "PC", assay.type = "RNA", seed.use = 42, ...)
}
\arguments{
\item{object}{Seurat object}

\item{pc.genes}{Genes to use as input for PCA. Default is object@var.genes}

\item{pcs.compute}{Total Number of PCs to compute and store (20 by default)}

\item{use.imputed}{Run PCA on imputed values (FALSE by default)}

\item{rev.pca}{By default computes the PCA on the cell x gene matrix. Setting
to true will compute it on gene x cell matrix.}

\item{weight.by.var}{Weight the cell embeddings by the variance of each PC
(weights the gene loadings if rev.pca is TRUE)}

\item{do.print}{Print the top genes associated with high/low loadings for
the PCs}

\item{pcs.print}{PCs to print genes for}

\item{genes.print}{Number of genes to print for each PC}

\item{reduction.name}{dimensional reduction name, specifies the position in the object$dr list. pca by default}

\item{reduction.key}{dimensional reduction key, specifies the string before the number for the dimension names. PC by default}

\item{assay.type}{Data type, RNA by default. Can be changed for multimodal}

\item{seed.use}{Set a random seed. By default, sets the seed to 42. Setting
NULL will not set a seed.}

\item{\dots}{Additional arguments to be passed to IRLBA}
}
\value{
Returns Seurat object with the PCA calculation stored in
object@dr$pca.
}
\description{
Run a PCA dimensionality reduction. For details about stored PCA calculation
parameters, see \code{PrintPCAParams}.
}
\examples{
pbmc_small
# Run PCA on variable genes (default)
pbmc_small <- RunPCA(pbmc_small)
# Run PCA on different gene set (in this case all genes)
pbmc_small=RunPCA(pbmc_small,pc.genes = rownames(pbmc_small@data))
# Run PCA but compute more than 20 dimensions
pbmc_small=RunPCA(pbmc_small,pcs.compute=30)
# Plot results
PCAPlot(pbmc_small)

}
