% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunMultiCCA}
\alias{RunMultiCCA}
\title{Perform Canonical Correlation Analysis with more than two groups}
\usage{
RunMultiCCA(object.list, genes.use, add.cell.ids = NULL, niter = 25,
  num.ccs = 1, standardize = TRUE)
}
\arguments{
\item{object.list}{List of Seurat objects}

\item{genes.use}{Genes to use in mCCA.}

\item{add.cell.ids}{Vector of strings to pass to \code{\link{RenameCells}} to
give unique cell names}

\item{niter}{Number of iterations to perform. Set by default to 25.}

\item{num.ccs}{Number of canonical vectors to calculate}

\item{standardize}{standardize scale.data matrices to be centered (mean zero)
and scaled to have a standard deviation of 1.}
}
\value{
Returns a combined Seurat object with the CCA stored in the @dr$cca slot.
}
\description{
Runs a canonical correlation analysis
}
\examples{
\dontrun{
pbmc_small
# As multi-set CCA requires more than two datasets, we will split our test object into
# three just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:30])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[31:60])
pbmc3 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[61:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc3@meta.data$group <- "group3"
pbmc.list <- list(pbmc1, pbmc2, pbmc3)
pbmc_cca <- RunMultiCCA(object.list = pbmc.list, genes.use = pbmc_small@var.genes, num.ccs = 3)
# Print results
PrintDim(pbmc_cca,reduction.type = 'cca')
}

}
