% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbj.R
\name{rbj}
\alias{rbj}
\title{Random number generation of Berk and Jones (BJ) statitic.}
\usage{
rbj(k, n, beta)
}
\arguments{
\item{k}{- number of observations.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct BJ statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
Random number from BJ statistics. The length of the result is determined by k for rbj.
}
\description{
Random number generation of Berk and Jones (BJ) statitic.
}
\examples{
## Generate a vector of 10 random numbers from BJ statistic when n = 100:
rbj(k=10, n=100, beta=1)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Jager, Leah; Wellner, Jon A. "Goodness-of-fit tests via phi-divergences". Annals of Statistics 35 (2007).
3. Berk, R.H. & Jones, D.H. Z. "Goodness-of-fit test statistics that dominate the Kolmogorov statistics". Wahrscheinlichkeitstheorie verw Gebiete (1979) 47: 47.
}
\seealso{
\code{\link{stat.bj}} for the definition of the statistic.
}

