% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceSpikeSlab.R
\name{SSS_hierarchical_prior}
\alias{SSS_hierarchical_prior}
\title{Compute marginal posterior probabilities (slab probabilities) that data points have
  non-zero mean for the hierarchical prior.}
\usage{
SSS_hierarchical_prior(log_phi_psi, logprior, show_progress = TRUE)
}
\arguments{
\item{log_phi_psi}{List \{logphi, logpsi\} containing two vectors of the same length n
that represent a preprocessed version of the data. logphi and logpsi should contain
the logs of the phi and psi densities of the data points, as produced for instance
by \code{\link{SSS_log_phi_psi_Laplace}} or \code{\link{SSS_log_phi_psi_Cauchy}}}

\item{logprior}{vector of length n+1 with components logprior[p]=log(pi_n(p)) for
\eqn{p=0,...,n}}

\item{show_progress}{Boolean that indicates whether to show a progress bar}
}
\value{
Returns a vector with marginal posterior slab probabilities that \eqn{x[i]} has
  non-zero mean for \eqn{i=1,...,n}.
}
\description{
Compute marginal posterior probabilities (slab probabilities) that data points have
  non-zero mean for the hierarchical prior.
}
