% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{random_module_structure}
\alias{random_module_structure}
\title{Create a random network structure for a module}
\usage{
random_module_structure(size, prob_rewire = 1, prob_remove = 0.5,
  weights = NULL, neig_size = 3, alpha = 100, beta = 1,
  epsilon = 10^-5, ...)
}
\arguments{
\item{size}{The number of nodes to include in the graph.}

\item{prob_rewire}{The probability of rewiring an edge.}

\item{prob_remove}{The probability of removing an edge.}

\item{weights}{(Optional) Weights used for sampling nodes. See 
?rewire_connections_to_node and ?remove_connections_to_node for details.}

\item{neig_size}{The neighborhood size within which the nodes of the 
ring lattice are connected. The initial degree of each node is 2 * 'neig_size',
so long as 'size' >= (1 + 2 * 'neig_size')}

\item{alpha}{A positive value used to parameterize the Beta distribution.}

\item{beta}{A positive value used to parameterize the Beta distribution.}

\item{epsilon}{A small constant added to the sampling probability of each node.}

\item{...}{Additional arguments are ignored.}
}
\value{
An adjacency matrix representing the network structure.
}
\description{
A single, connected graph is created. The graph is initialized as a ring 
lattice, and edges are randomly rewired and/or removed. The procedure
is similar to the Watts-Strogatz method, but the sampling of edges to 
modify can be based on the degree of each node.
}
\examples{
# Create a random module structure (an adjacency matrix) for 10 nodes.
adj_mat <- random_module_structure(10)
# A network object can be created using this structure.
module <- create_module_from_adjacency_matrix(adj_mat)
nw <- create_network_from_modules(10, module)
}
