% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.network}
\alias{plot.network}
\title{Plot function for 'network' object}
\usage{
\method{plot}{network}(x, compare_graph = NULL, show_modules = FALSE,
  as_subgraph = FALSE, ...)
}
\arguments{
\item{x}{A 'network' object.}

\item{compare_graph}{The plot of another network to use for comparison.}

\item{show_modules}{If TRUE, the modules will highlighted in the graph. 
Defaults to FALSE if there is exactly one module in the network and to TRUE
otherwise.}

\item{as_subgraph}{If TRUE, only nodes of positive degree will be shown. 
Defaults to FALSE if there are 100 or fewer nodes in the network and to TRUE
otherwise.}

\item{...}{Additional arguments passed to plot_modules() or plot_network().}
}
\value{
Creates a plot of the module and returns a graph object. 
See ?plot_modules and ?plot_network for details.

A 'network_plot' object for the network. This object can be passed 
back into a future call of plot.network() through the `compare_graph` 
argument, which will setup the plot for easier comparison between the old 
graph and the new graph of `network`.
}
\description{
This function plots the given network. If the result of another plot is 
provided, this plot will be modified for easier comparison.
}
\examples{
nw <- random_network(10)
plot(nw)
}
