% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.table.R
\name{combine.table}
\alias{combine.table}
\title{Combine Table}
\usage{
combine.table(test.table, somatic, mutdistance, segnum, output.name)
}
\arguments{
\item{test.table}{Data frame of kataegis test scores}

\item{somatic}{Data frame of somatic variants}

\item{mutdistance}{The maximum intermutational distance allowed for SNVs to be grouped in the same kataegic event. Recommended value: 3.2}

\item{segnum}{Minimum mutation count. The minimum number of mutations required within a cluster to be identified as kataegic. Recommended value: 4}

\item{output.name}{Name of the generated output directory.}
}
\description{
Merges overlapped windows to identify genomic boundaries of kataegic events. This function also assigns hypermuation and kataegic score for combined windows
}
\examples{
load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/somatic.rda"
		)
	);

load(
	paste0(
		path.package("SeqKat"),
		"/extdata/test/final.score.rda"
		)
	);

combine.table(
	final.score,
	somatic,
	3.2,
	4,
	tempdir()
	);
}
\author{
Fouad Yousif

Fan Fan
}
