% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SentimentDictionaryWeighted}
\alias{plot.SentimentDictionaryWeighted}
\title{KDE plot of estimated coefficients}
\usage{
\method{plot}{SentimentDictionaryWeighted}(x, color = "gray60",
  theme = ggplot2::theme_bw(), ...)
}
\arguments{
\item{x}{Dictionary of class \code{\link{SentimentDictionaryWeighted}}}

\item{color}{Color for filling the density plot (default: gray color)}

\item{theme}{Visualization theme for \code{\link[ggplot2]{ggplot}} (default: is a black-white theme)}

\item{...}{Additional parameters passed to function.}
}
\value{
Returns a plot of class \code{\link[ggplot2]{ggplot}}
}
\description{
Function performs a Kernel Density Estimation (KDE) of the coefficients and then
plot these using \code{\link[ggplot2]{ggplot}}. This type of plot allows to 
inspect whether the distribution of coefficients is skew. This can reveal if there
are more positive terms than negative or vice versa.
}
\examples{
d <- SentimentDictionaryWeighted(character(100), rnorm(100), numeric(100))
plot(d)

# Change color in plot
plot(d, color="red")

library(ggplot2)
# Extend plot with additional layout options
plot(d) + ggtitle("KDE plot")
plot(d) + theme_void() 
}
\seealso{
\code{\link{plotSentiment}} and \code{\link{plotSentimentResponse}} for further plotting options
}
\keyword{evaluation}
\keyword{plots}
