% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_cv.R
\name{var_select_all}
\alias{var_select_all}
\alias{lasso_msgps_all}
\alias{enet_msgps_all}
\alias{alasso_msgps_all}
\alias{alasso_enet_msgps_all}
\alias{lasso_cv_glmnet_all_5f}
\alias{spls_spls_all}
\alias{varbvs_linear_all}
\alias{lasso_cv_glmnet_bin_all}
\alias{lasso_glmnet_bin_all}
\alias{splsda_spls_all}
\alias{sgpls_spls_all}
\alias{varbvs_binomial_all}
\title{Variable selection functions (all)}
\usage{
lasso_msgps_all(X, Y, penalty = "enet")

enet_msgps_all(X, Y, penalty = "enet", alpha = 0.5)

alasso_msgps_all(X, Y, penalty = "alasso")

alasso_enet_msgps_all(X, Y, penalty = "alasso", alpha = 0.5)

lasso_cv_glmnet_all_5f(X, Y)

spls_spls_all(X, Y, K.seq = c(1:5), eta.seq = (1:9)/10, fold.val = 5)

varbvs_linear_all(X, Y, include.threshold.list = (1:19)/20)

lasso_cv_glmnet_bin_all(X, Y)

lasso_glmnet_bin_all(X, Y)

splsda_spls_all(X, Y, K.seq = c(1:10), eta.seq = (1:9)/10)

sgpls_spls_all(X, Y, K.seq = c(1:10), eta.seq = (1:9)/10)

varbvs_binomial_all(X, Y, include.threshold.list = (1:19)/20)
}
\arguments{
\item{X}{A numeric matrix. The predictors matrix.}

\item{Y}{A binary factor. The 0/1 classification response.}

\item{penalty}{A character value to select the penalty term in msgps
(Model Selection Criteria via Generalized Path Seeking). Defaults to "enet".
"genet" is the generalized elastic net and "alasso" is the adaptive lasso,
which is a weighted version of the lasso.}

\item{alpha}{A numeric value to set the value of \eqn{\alpha} on "enet" and "genet" penalty in msgps
(Model Selection Criteria via Generalized Path Seeking).}

\item{K.seq}{A numeric vector. Number of components to test.}

\item{eta.seq}{A numeric vector. Eta sequence to test.}

\item{fold.val}{A numeric value. Number of folds to use.}

\item{include.threshold.list}{A numeric vector. Vector of threshold to use.}

\item{K}{A numeric value. Number of folds to use.}
}
\value{
A vector or matrix of coefficients.
}
\description{
Compute coefficient vector after variable selection for the fitting criteria of a given model. May be used for a step by step use of Selectboost.
}
\details{
\code{lasso_msgps_all} returns the matrix of coefficients
for an optimal linear model estimated by the LASSO estimator and selected
by model selection criteria including Mallows' Cp, bias-corrected AIC (AICc),
generalized cross validation (GCV) and BIC.
The the \code{msgps} function of the \code{msgps} package implements
Model Selection Criteria via Generalized Path Seeking to compute the degrees
of freedom of the LASSO.

\code{enet_msgps_all} returns the matrix of coefficients
for an optimal linear model estimated by the ELASTIC NET estimator and selected
by model selection criteria including Mallows' Cp, bias-corrected AIC (AICc),
generalized cross validation (GCV) and BIC.
The the \code{msgps} function of the \code{msgps} package implements
Model Selection Criteria via Generalized Path Seeking to compute the degrees
of freedom of the ELASTIC NET.

\code{alasso_msgps_all} returns the matrix of coefficients
for an optimal linear model estimated by the adaptive LASSO estimator and selected
by model selection criteria including Mallows' Cp, bias-corrected AIC (AICc),
generalized cross validation (GCV) and BIC.
The the \code{msgps} function of the \code{msgps} package implements
Model Selection Criteria via Generalized Path Seeking to compute the degrees
of freedom of the adaptive LASSO.

\code{alasso_enet_msgps_all} returns the matrix of coefficients
for an optimal linear model estimated by the adaptive ELASTIC NET estimator and selected
by model selection criteria including Mallows' Cp, bias-corrected AIC (AICc),
generalized cross validation (GCV) and BIC.
The the \code{msgps} function of the \code{msgps} package implements
Model Selection Criteria via Generalized Path Seeking to compute the degrees
of freedom of the adaptive ELASTIC NET.

\code{lasso_cv_glmnet_all_5f} returns the matrix of coefficients
for a linear model estimated by the LASSO using the \code{lambda.min} and \code{lambda.1se}
(lambda.min+1se) values computed by 5 fold cross validation. It uses the \code{glmnet}
and \code{cv.glmnet} functions of the \code{glmnet} package.

\code{spls_spls_all} returns the matrix of the raw (\code{coef.spls})
and \code{correct.spls} and bootstrap corrected coefficients
for a linear model estimated by the SPLS (sparse partial least squares) and 5 fold cross validation.
It uses the \code{spls}, \code{cv.spls}, \code{ci.spls}, \code{coef.spls} and
\code{correct.spls} functions of the \code{spls} package.

\code{varbvs_linear_all} returns the matrix of the coefficients
for a linear model estimated by the varbvs (variational approximation for Bayesian
variable selection in linear regression, \code{family = gaussian}) and the requested threshold values.
It uses the \code{varbvs}, \code{coef} and \code{variable.names} functions of the \code{varbvs} package.

\code{lasso_cv_glmnet_bin_all} returns the matrix of coefficients
for a logistic model estimated by the LASSO using the \code{lambda.min} and \code{lambda.1se}
(lambda.min+1se) values computed by 5 fold cross validation. It uses the \code{glmnet} and \code{cv.glmnet}
functions of the \code{glmnet} package.

\code{lasso_glmnet_bin_all} returns the matrix of coefficients
for a logistic model estimated by the LASSO using the \code{AICc_glmnetB} and \code{BIC_glmnetB}
information criteria. It uses the \code{glmnet} function of the \code{glmnet} package and the
\code{AICc_glmnetB} and \code{BIC_glmnetB} functions of the \code{SelectBoost} package that were
adapted from the \code{AICc_glmnetB} and \code{BIC_glmnetB} functions of the \code{rLogistic}
(\url{https://github.com/echi/rLogistic}) package.

\code{splsda_spls_all} returns the matrix of the raw (\code{coef.splsda}) coefficients
for logistic regression model estimated by the SGPLS (sparse généralized partial least squares) and
5 fold cross validation. It uses the \code{splsda}, \code{cv.splsda} and \code{coef.splsda} functions
of the \code{sgpls} package.

\code{sgpls_spls_all} returns the matrix of the raw (\code{coef.sgpls}) coefficients
for logistic regression model estimated by the SGPLS (sparse généralized partial least squares) and
5 fold cross validation. It uses the \code{sgpls}, \code{cv.sgpls} and \code{coef.sgpls} functions
of the \code{sgpls} package.

\code{varbvs_binomial_all} returns the matrix of the coefficients
for a linear model estimated by the varbvs (variational approximation for Bayesian
variable selection in logistic regression, \code{family = binomial}) and the requested threshold values.
It uses the \code{varbvs}, \code{coef} and \code{variable.names} functions of the \code{varbvs} package.
}
\examples{
set.seed(314)
xran <- matrix(rnorm(100*6),100,6)
beta0 <- c(3,1.5,0,0,2,0)
epsilon <- rnorm(100,sd=3)
yran <- c(xran \%*\% beta0 + epsilon)
ybin <- ifelse(yran>=0,1,0)
set.seed(314)
lasso_msgps_all(xran,yran)

set.seed(314)
enet_msgps_all(xran,yran)

set.seed(314)
alasso_msgps_all(xran,yran)

set.seed(314)
alasso_enet_msgps_all(xran,yran)

set.seed(314)
lasso_cv_glmnet_all_5f(xran,yran)

set.seed(314)
spls_spls_all(xran,yran)

set.seed(314)
varbvs_linear_all(xran,yran)

set.seed(314)
lasso_cv_glmnet_bin_all(xran,ybin)

set.seed(314)
lasso_glmnet_bin_all(xran,ybin)

set.seed(314)
\donttest{
splsda_spls_all(xran,ybin, K.seq=1:3)
}

set.seed(314)
\donttest{
sgpls_spls_all(xran,ybin, K.seq=1:3)
}

set.seed(314)
varbvs_binomial_all(xran,ybin)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, Bioinformatics, 2020. \doi{10.1093/bioinformatics/btaa855}
}
\seealso{
\code{\link[glmnet]{glmnet}}, \code{\link[glmnet]{cv.glmnet}}, \code{\link[msgps]{msgps}}, \code{\link{AICc_BIC_glmnetB}}, \code{\link[spls]{spls}}, \code{\link[spls]{cv.spls}}, \code{\link[spls]{correct.spls}}, \code{\link[spls]{splsda}}, \code{\link[spls]{cv.splsda}}, \code{\link[spls]{sgpls}}, \code{\link[spls]{cv.sgpls}}, \code{\link[varbvs]{varbvs}}

Other Variable selection functions: 
\code{\link{var_select}}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@utt.fr}
}
\concept{Variable selection functions}
