% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC_AICc_glmnet.R
\name{AICc_BIC_glmnetB}
\alias{AICc_BIC_glmnetB}
\alias{rerr}
\alias{ridge_logistic}
\alias{BIC_glmnetB}
\alias{AICc_glmnetB}
\title{AICc and BIC for glmnet logistic models}
\usage{
rerr(v1, v2)

ridge_logistic(X, Y, lambda, beta0, beta, maxiter = 1000, tol = 1e-10)

BIC_glmnetB(Z, Y, glmnet.model, alpha, modelSet, reducer = "median")

AICc_glmnetB(Z, Y, glmnet.model, alpha, modelSet, reducer = "median")
}
\arguments{
\item{v1}{A numeric vector.}

\item{v2}{A numeric vector.}

\item{X}{A numeric matrix}

\item{Y}{A numeric 0/1 vector.}

\item{lambda}{A numeric value.}

\item{beta0}{A numeric value Initial intercept value.}

\item{beta}{A numeric vector. Initial coefficient values.}

\item{maxiter}{A numeric value. Maximum number of iterations.}

\item{tol}{A numeric value. Tolerance value.}

\item{Z}{A numeric matrix}

\item{glmnet.model}{A fitted glmnet model.}

\item{alpha}{A numeric value.}

\item{modelSet}{Modelset to consider.}

\item{reducer}{A character value. Reducer function. Either 'median' or 'mean'.}
}
\value{
A list relevant to model selection.
}
\description{
Compute AICc and BIC for glmnet logistic models.
}
\details{
Calculate AICc and BIC for glmnet logistic models from the glmnetB function
of the package rLogistic \url{https://github.com/echi/rLogistic} and adapted
to deal with non finite exponential values in AICc and BIC computations
}
\examples{
set.seed(314)
xran=matrix(rnorm(150),30,5)
ybin=sample(0:1,30,replace=TRUE)
glmnet.fit <- glmnet.fit <- glmnet::glmnet(xran,ybin,family="binomial",standardize=FALSE)
set.seed(314)
rerr(1:10,10:1)

set.seed(314)
ridge_logistic(xran,ybin,lambda=.5,beta0=rnorm(5),beta=rnorm(5,1))

set.seed(314)
if(is.factor(ybin)){ynum=unclass(ybin)-1} else {ynum=ybin}
subSample <- 1:min(ncol(xran),100)
BIC_glmnetB(xran,ynum,glmnet.fit,alpha=1,subSample, reducer='median')

set.seed(314)
if(is.factor(ybin)){ynum=unclass(ybin)-1} else {ynum=ybin}
subSample <- 1:min(ncol(xran),100)
AICc_glmnetB(xran,ynum,glmnet.fit,alpha=1,subSample, reducer='median')

}
\references{
\emph{Robust Parametric Classification and Variable Selection by a Minimum Distance Criterion}, Chi and Scott, Journal of Computational and Graphical Statistics, \bold{23}(1), 2014, p111--128, \doi{10.1080/10618600.2012.737296}.
}
\seealso{
\code{\link{var_select}}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@utt.fr}
}
