% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{disc_score_dt}
\alias{disc_score_dt}
\title{Generalized Discrimination score}
\usage{
disc_score_dt(year, obs, pB, pN, pA)
}
\arguments{
\item{year}{a vector of pool variables, typically year.}

\item{obs}{a vector of observations the observation column, needs to contain -1 if it falls into the first category,
0 for the second and 1 for the third category.}

\item{pB}{a vector of probabilities for the first category.}

\item{pN}{a vector of probabilities for the second category.}

\item{pA}{a vector of probabilities for the third category.}
}
\value{
A data table with the scores
}
\description{
Calculate the Generalized discrimination score from a data.table with data belonging to a single group (as defined by the
by variable in the DISS function), for example a single location and month.
Formula (5a) from Mason&2018 is used in the calculation. Mostly auxiliary function for the DISS function.
}
\examples{
disc_score_dt(year = 1999:2001,
             obs = c(-1,0,0),
             pB = c(0.5,0.3,0),
             pN = c(0.3,0.3,0.7),
             pA = c(0.2,0.4,0.3))

}
