% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\name{download_chirps_monthly}
\alias{download_chirps_monthly}
\title{Download monthly CHIRPS-data}
\usage{
download_chirps_monthly(
  resolution = "both",
  update = TRUE,
  version = "UCSB",
  years = NULL,
  months = NULL,
  extent = GHA_extent(),
  timeout_limit = 300,
  upscale_grid = data.table(expand.grid(lon = seq(extent[1], extent[2], 0.5), lat =
    seq(extent[3], extent[4], 0.5)))
)
}
\arguments{
\item{resolution}{Shall the data be upscaled? Takes one of three arguments:
\itemize{
\item \strong{'both'} (the default) downloads and saves the data on full resolution and additionally derives an upscaled version. Both will be available later.
\item \strong{'high'} downloads and saves on original resolution, but does not upscale.
\item \strong{'low'} (for saving disk space) downloads the original resolution, upscales immediately and only saves the upscaled version.
}}

\item{update}{Logical, if TRUE, previously created files are skipped.}

\item{version}{Should be 'UCSB' (for University of California Santa Barbara, the original source of CHIRPS) or 'ICPAC' (for downloading the ICPAC version CHIRPS blended)}

\item{years, months}{Which years and months do you want to load? NULL loads everything there is.}

\item{extent}{vector of length four (xmin,xmax,ymin,ymax), restricting the spatial area.}

\item{timeout_limit}{how many seconds (per file, i.e. per yearmonth) before the download is aborted?}

\item{upscale_grid}{The coarse grid to which the data is upscaled (only used when resolution is either 'both' or 'high'). Only change this if you know what you are doing.}
}
\value{
Nothing.
}
\description{
Download CHIRPS monthly data for the GHA-region and save it as netcdfs.
The data is downloaded either from the IRI data library or from ICPAC (depending on \code{version}), because these data library allows to subset before downloading,
unlike the original source at UCSB.
As of Feb 2022, the entire CHIRPS-monthly data for the GHA-region is roughly 800MB on disk.
The original spatial resolution of CHIRPS is 0.05 degree lon/lat. However, for many applications a coarser resolution is perfectly fine.
The function therefore offers the option to also create and save a coarser, upscaled version of the CHIRPS data that allows much faster data processing.
Alternatively you can also ONLY save the upscaled version to save disk space (roughly 8MB on disk).
}
\examples{
if(interactive()){
download_chirps_monthly(years = 2020, months = 1)
}

}
