% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/factorize.R
\encoding{UTF-8}
\name{factorize}
\alias{factorize}
\alias{factorize.character}
\alias{factorize.data.frame}
\alias{factorize.default}
\alias{factorize.numeric}
\title{Conditionally convert vectors to factors}
\usage{
factorize(x, ...)

\method{factorize}{default}(x, ...)

\method{factorize}{numeric}(x, max.levels = 10L, ...)

\method{factorize}{character}(x, max.levels = 10L, ...)

\method{factorize}{data.frame}(x, max.levels = 10L, ...)
}
\arguments{
\item{x}{an object.}

\item{...}{additional arguments (currently ignored)}

\item{max.levels}{an integer that determines the number of unique values to be coverted. Default is \code{max.levels = 10}.}
}
\description{
A generic function and several instances for creating factors from
other sorts of data. The primary use case is for vectors that contain
few unique values and might be better considered as factors. When
applied to a data frame, this is applied to each column in the data.frame.
}
\examples{
#Some data
ID = 1:10
Age = round(rnorm(10,50,1))
diag = c("Depression","Bipolar");
Diagnosis = sample(diag, 10, replace=TRUE)
data = data.frame(ID, Age, Diagnosis)
factorize(data$Diagnosis)
str(factorize(data))
}

