% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_circos_links.R
\name{make_circos_links}
\alias{make_circos_links}
\title{make_circos_links}
\usage{
make_circos_links(df, chromosome_grouping, band_grouping, link_grouping,
  start_position, end_position, status = FALSE)
}
\arguments{
\item{df}{A data frame in the format of those returned by the `make_circos_df_*` functions}

\item{chromosome_grouping}{A column defining the circos chromosomes. Passed as column index or "column name".}

\item{band_grouping}{A column defining the circos chromosome bands. Passed as column index or "column name".}

\item{link_grouping}{A column defining the circos linkage IDs. Passed as column index or "column name".}

\item{start_position}{A column defining the start positions of the linkage ID.}

\item{end_position}{A column defining the end positions of the linkage ID.}

\item{status}{Defaults to FALSE. Removes parallelized computing, and provides a status bar to track progress.}
}
\value{
Returns a links data frame suitable for filtering and exporting using the `write_circos_links()` function.
}
\description{
A function that takes a data frame in the format of those returned by the `make_circos_df_*` functions, and returns
a data frame containing all possible lineage links, and some additional metadata about each link for filtering purposes.

***NOTE: This function is optimized for parallelized computing. Setting the "status" argument to true will
eliminate this feature, and instead provide a status bar to track progress.
}
\examples{

links_df <- data.frame(chrom = c(rep("chr1", 5), rep("chr2", 5)),
band = c(rep("band1", 3), rep("band2", 2), "band1", rep("band2", 4)),
link = c(1, 2, 3, 1, 2, 1, 1, 3, 4, 5),
start = c(1, 3, 5, 10, 35, 1, 5, 8, 13, 15),
end = c(3, 5, 10, 35, 39, 5, 8, 13, 15, 21))

links <- make_circos_links(links_df, "chrom", "band", "link", "start", "end", status = TRUE)

print(links)
}
\author{
Matthew Woodruff, Emory University
}
