% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEWAquarius.R
\name{AQWPDownload}
\alias{AQWPDownload}
\title{Function to download data from https://water.data.sa.gov.au}
\usage{
AQWPDownload(
  Location,
  Dataset,
  Unit,
  file = "AQWP.json",
  Interval = "Daily",
  Calculation = "Aggregate",
  Calendar = "CALENDARYEAR",
  Step = 1,
  DateRange = "EntirePeriodOfRecord",
  StartTime = NULL,
  EndTime = NULL
)
}
\arguments{
\item{Location}{A string or vector of strings, with site numbers, e.g. "A4261001"}

\item{Dataset}{A string or vector of strings, with dataset names, as expected by AWQP, e.g. "Tide Height.Best Available--Continuous"}

\item{Unit}{A string or vector of strings, with units, e.g. "Metres" or "mg/L". If only 1 is string is provided it will be used for each site in Location}

\item{file}{Location and name of json file to download. Defaults to "AQWP.json".}

\item{Interval}{Interval of output, e.g. "PointsAsRecorded", or "Daily"}

\item{Calculation}{For larger intervals, what calculation to do, e.g. "Aggregate" (average) or "Maximum"}

\item{Calendar}{When to start the periods, e.g. "WATERDAY9AM"}

\item{Step}{How many intervals e.g. 15 with Interval="Minutely" returns 15 minute data.}

\item{DateRange}{Period of data to return, e.g. "EntirePeriodOfRecord" or "Custom". "Years1" seems to not work on AWQP.}

\item{StartTime}{Start Date and Time if DateRange="Custom", in a format that as.POSIXct will convert, e.g 2000-01-01 00:00}

\item{EndTime}{End Date and Time if DateRange="Custom", in a format that as.POSIXct will convert, e.g 2001-01-02 00:00}
}
\value{
The lnk created to download the data, which is useful for debugging. The data is saved to "file", that can then be read in with AQWPLoad()
}
\description{
For most inputs, valid options will be returned if an unexpected input is provided. 
The exception are \strong{Location} and \strong{Dataset}, if the location, or dataset for that location, don't exist no data will be returned.
Browse the Export tab on https://water.data.sa.gov.au to find \strong{Location} and \strong{Dataset} that exists.
}
\examples{
\dontrun{
Location=c("A4260633","A4261209","A4260572")
Dataset=rep("Tide Height.Best Available--Continuous",3)
Unit=rep("Metres",3)
S="2020-01-01 00:00"
E="2020-01-02 00:00"
AQWPDownload(Location,Dataset,Unit,DateRange="Custom",
StartTime=S,EndTime=E,file=tempfile("AQWP",fileext=".json"))
}

}
