% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_VaR_ES.R
\name{stress_VaR_ES}
\alias{stress_VaR_ES}
\title{Stressing Value-at-Risk and Expected Shortfall}
\usage{
stress_VaR_ES(x, alpha, q_ratio = NULL, s_ratio = NULL, q = NULL,
  s = NULL, k = 1)
}
\arguments{
\item{x}{A vector, matrix or data frame 
containing realisations of random variables. Columns of \code{x} 
correspond to random variables; OR\cr
A \code{SWIM} object, where \code{x} corresponds to the 
underlying data of the \code{SWIM} object.}

\item{alpha}{Numeric vector, the levels of the stressed VaR.}

\item{q_ratio}{Numeric vector, the ratio of the stressed VaR to the
baseline VaR.\cr
If \code{alpha} and \code{q_ratio} are vectors, they 
must have the same length.}

\item{s_ratio}{Numeric, vector, the ratio of the stressed ES to 
the baseline ES.\cr
If \code{q} (\code{q_ratio}) and \code{s_ratio} are vectors, 
they must have the same length.}

\item{q}{Numeric vector, the stressed VaR at level 
\code{alpha}.\cr
If \code{alpha} and \code{q} are vectors, they must 
have the same length.}

\item{s}{Numeric, vector, the stressed ES at level 
\code{alpha}.\cr
If \code{q} and \code{s} are vectors, they must have
the same length.}

\item{k}{Numeric, the column of \code{x} that is stressed
\code{(default = 1)}.}
}
\value{
A \code{SWIM} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{new_weights}, a list of functions, that applied to 
  the \code{k}th column of \code{x}, generates the vectors of scenario 
  weights. Each component corresponds to a different stress;
     \item \code{type = "VaR ES"};
     \item \code{specs}, a list, each component corresponds to 
   a different stress and contains \code{k}, \code{alpha}, 
   \code{q} and \code{s}.
    }
    See \code{\link{SWIM}} for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that a stressed model component (random variable) fulfils a 
    constraint on its Value-at-Risk (VaR) and Expected Shortfall (ES) risk 
    measures, both evaluated at a given level. Scenario weights are 
    selected by constrained minimisation of the relative entropy to the 
    baseline model.
}
\details{
The VaR at level \code{alpha} of a random variable with 
    distribution function F is defined as its left-quantile at \code{alpha}:
    \deqn{VaR_alpha = F^{-1}(alpha).}
    
    The ES at level \code{alpha} of a random variable with distribution 
    function F is defined by:
    \deqn{ES_alpha = 1 / (1 - alpha) * int_alpha^1 VaR_u d u.}

    The stressed VaR and ES are the risk measures of the chosen model 
    component, subject to the calculated scenario weights. If one 
    of \code{alpha, q, s} (\code{q_ratio, s_ratio}) is 
    a vector, the stressed VaR's and ES's of the \code{k}th column of  
    \code{x}, at levels \code{alpha}, are equal to \code{q} 
    and \code{s}, respectively.
}
\examples{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR ES", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05, s_ratio = 1.08)
  
## calling stress_VaR_ES directly   
## stressing "gamma"
res2 <- stress_VaR_ES(x = x, alpha = 0.9, 
  q_ratio = 1.03, s_ratio = c(1.05, 1.08), k = 2)
get_specs(res2)
summary(res2)
            
}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Csiszar1975}{SWIM}
}
\seealso{
Other stress functions: \code{\link{stress_VaR}},
  \code{\link{stress_mean_sd}}, \code{\link{stress_mean}},
  \code{\link{stress_moment}}, \code{\link{stress_prob}},
  \code{\link{stress_user}}, \code{\link{stress}}
}
\concept{stress functions}
