% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.svemtest.R
\name{plot.svem_significance_test}
\alias{plot.svem_significance_test}
\title{Plot SVEM Significance Test Results for Multiple Responses}
\usage{
\method{plot}{svem_significance_test}(..., labels = NULL)
}
\arguments{
\item{...}{One or more objects of class \code{svem_significance_test}, which are the outputs from \code{\link{svem_significance_test}}.}

\item{labels}{Optional character vector of labels for the responses. If not provided, the function uses the response variable names.}
}
\value{
A \code{ggplot} object showing the distributions of Mahalanobis distances for all responses.
}
\description{
Plots the Mahalanobis distances for the original and permuted data from multiple SVEM significance test results.
}
\details{
This function creates a combined plot of the Mahalanobis distances (\code{d_Y} and \code{d_pi_Y}) for the original and permuted data from multiple SVEM significance test results. It groups the data by response and source type, displaying original and permutation distances side by side for each response.

**Usage Notes:**
\itemize{
  \item Use this function to compare the significance test results across multiple responses.
  \item The plot shows original and permutation distances next to each other for each response.
}
}
\section{Acknowledgments}{

Development of this package was assisted by GPT o1-preview, which helped in constructing the structure of some of the code and the roxygen documentation. The code for the significance test is taken from the supplementary material of Karl (2024) (it was handwritten by that author).
}

