% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{display_motifsDataset}
\alias{display_motifsDataset}
\title{Plot a heatmap of the dataset and highlight the selected motifs from the list}
\usage{
display_motifsDataset(dataset, rstmotifs, alpha)
}
\arguments{
\item{dataset}{Numerical dataset}

\item{rstmotifs}{List of ranked motifs}

\item{alpha}{The cardinality of the SAX alphabet}
}
\value{
Heatmap dataset with seelected motifs
}
\description{
Plot a heatmap of the dataset and highlight the selected motifs from the list
}
\examples{
#Launch all the workflow
#Plot the result
D  <- STMotif::example_dataset
DS <- NormSAX(STMotif::example_dataset,5)
stmotifs <- SearchSTMotifs(D,DS,4,5,4,10,2,2)
rstmotifs <- RankSTMotifs(stmotifs)
display_motifsDataset(dataset = STMotif::example_dataset, rstmotifs[c(1:4)],  5)
}
