# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Plug-in estimates of local false discovery rate
#' @description Calculate the plug-in estimates of local false discovery rate across two studies.
#' @param xi00 The prior probability for joint state (0, 0).
#' @param xi01 The prior probability for joint state (0, 1).
#' @param xi10 The prior probability for joint state (1, 0).
#' @param xi11 The prior probability for joint state (1, 1).
#' @param f1 The non-null probability density function in study 1.
#' @param f2 The non-null probability density function in study 2.
#'
#' @return
#' \item{Lfdr}{The plug-in estimates of local false discovery rate for all features.}
#'
NULL

#' @title Calculate the adjusted value of local false discovery rate for FDR control
#' @description Apply a step-up procedure based on the local false discovery rate to obtain the adjusted values for FDR control.
#' @param Lfdr The local false discovery rate for all features.
#'
#' @return
#' \item{lfdr_adj}{The adjusted local false discovery rate values for FDR control.}
#'
NULL

#' @title Pool-adjacent-violator-algorithm to fit the isotonic regression.
#' @description The pool-adjacent-violator-algorithm is applied to fit the isotonic regression of a set of data.
#' @param values A numeric vector of data whose isotonic regression is to be calculated.
#' @param weight The weight vector to be used for a weighted isotonic regression.
#' @param decreasing A logical scalar that specifies the order of the isotonic regression (1 if decreasing; 0 otherwise).
#'
#' @return
#' \item{xx}{The fitted values of the data.}
#'
NULL

#' @title EM algorithm to estimate local false discovery rate
#' @description Estimate the local false discovery rate across two studies and apply a step-up procedure to control the FDR of replicability null.
#' @param pa_in A numeric vector of p-values from study 1.
#' @param pb_in A numeric vector of p-values from study 2.
#' @param pi0a_in An initial estimate of the null probability in study 1.
#' @param pi0b_in An initial estimate of the null probability in study 2.
#'
#' @return
#' \item{Lfdr}{The estimated local false discovery rate for replicability null.}
#' \item{fdr}{The adjusted values based on local false discovery rate for FDR control.}
#' \item{xi00}{An estimate of the prior probability for joint state (0, 0).}
#' \item{xi01}{An estimate of the prior probability for joint state (0, 1).}
#' \item{xi10}{An estimate of the prior probability for joint state (1, 0).}
#' \item{xi11}{An estimate of the prior probability for joint state (1, 1).}
#' \item{f1}{A non-parametric estimate for the non-null probability density function in study 1.}
#' \item{f2}{A non-parametric estimate for the non-null probability density function in study 2.}
#'
#' @export
em_lfdr <- function(pa_in, pb_in, pi0a_in, pi0b_in) {
    .Call(`_STAREG_em_lfdr`, pa_in, pb_in, pi0a_in, pi0b_in)
}

