% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_func.R
\name{pred_ssnbayes}
\alias{pred_ssnbayes}
\title{Internal function used to perform spatio-temporal prediction in R using a stanfit object from ssnbayes()}
\usage{
pred_ssnbayes(
  object = object,
  path = path,
  obs_data = obs_data,
  pred_data = pred_data,
  net = 1,
  nsamples = 100,
  addfunccol = "afvArea",
  locID_pred = locID_pred,
  chunk_size = chunk_size,
  seed = seed
)
}
\arguments{
\item{object}{A stanfit object returned from ssnbayes}

\item{path}{Path with the name of the SpatialStreamNetwork object}

\item{obs_data}{The observed data frame}

\item{pred_data}{The predicted data frame}

\item{net}{(optional) Network from the SSN object}

\item{nsamples}{The number of samples to draw from the posterior distributions. (nsamples <= iter)}

\item{addfunccol}{The variable used for spatial weights}

\item{locID_pred}{(optional) the location id for the predictions. Used when the number of pred locations is large.}

\item{chunk_size}{(optional) the number of locID to make prediction from}

\item{seed}{(optional) A seed for reproducibility}
}
\value{
A data frame
}
\description{
Use predict.ssnbayes() instead.
It will take an observed and a prediction data frame.
It requires the same number of observation/locations per day.
It requires location id (locID) and points id (pid).
The locID are unique for each site.
The pid is unique for each observation.
Missing values are allowed in the response but not in the covariates.
}
\examples{
#pred <- pred_ssnbayes(path = path,
#obs_data = clear,
#stanfit = fit_ar,
#pred_data = preds,
#net = 2,
#nsamples = 100, # number of samples to use from the posterior in the stanfit object
#addfunccol = 'afvArea') # variable used for spatial weights
}
\author{
Edgar Santos-Fernandez
}
