% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funMarkovChain.R
\name{parseTunedRegionModel}
\alias{parseTunedRegionModel}
\title{parseTunedRegionModel}
\usage{
parseTunedRegionModel(xList)
}
\arguments{
\item{xList}{list of results from \code{\link{spot}} run}
}
\value{
returns the following list of 3:
\describe{
	\item{\code{models}}{data.frame with obs. of  7 variables:
     \describe{
	          \item{\code{p}}{num, e.g., 27373033}
	          \item{\code{beta}}{num}
	           \item{\code{gamma}}{num}
	           \item{\code{CFR}}{num}
	           \item{\code{cost}}{num}
	           \item{\code{region}}{ chr, e.g., "Afghanistan/"}
	           \item{\code{regionPopulation}}{ num population}
               }
     }
     \item{\code{pops}}{list of x values for countries, i.e., \code{\link{spot}} population generated at
     each generation, e.g., \code{ Afghanistan/: num [1:6, 1:4] 32039478 28078906 23529925 11257083 9883189 ...}}.
     Here, 6 function evaluations were performed and the search space is 4-dim.
     \item{\code{y}}{function values for pops}
     }
}
\description{
Parse results from the \code{\link{tuneRegionModel}} function, i.e.,
results from a \code{\link{spot}} run on \code{\link{funMarkovChain}}
}
\examples{
\donttest{
require("SimInf")
require("SPOT")
data <- preprocessInputData(regionTrain, regionPopulation)
resList <- lapply(data[1], tuneRegionModel, pops=NULL, control=list(funEvals=6,
designControl=list(size=5), model = buildLM))
parsedList <- parseTunedRegionModel(resList)
}
}
