% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kerasOptimizer.R
\name{optimizer_adamax}
\alias{optimizer_adamax}
\title{Adamax optimizer}
\usage{
optimizer_adamax(
  learning_rate = 0.002,
  beta_1 = 0.9,
  beta_2 = 0.999,
  epsilon = NULL,
  decay = 0,
  clipnorm = NULL,
  clipvalue = NULL,
  ...
)
}
\arguments{
\item{learning_rate}{float >= 0. Learning rate.}

\item{beta_1}{The exponential decay rate for the 1st moment estimates. float,
0 < beta < 1. Generally close to 1.}

\item{beta_2}{The exponential decay rate for the 2nd moment estimates. float,
0 < beta < 1. Generally close to 1.}

\item{epsilon}{float >= 0. Fuzz factor. If `NULL`, defaults to `k_epsilon()`.}

\item{decay}{float >= 0. Learning rate decay over each update.}

\item{clipnorm}{Gradients will be clipped when their L2 norm exceeds this
value.}

\item{clipvalue}{Gradients will be clipped when their absolute value exceeds
this value.}

\item{...}{Unused, present only for backwards compatability}
}
\description{
Adamax optimizer from Section 7 of the [Adam paper](https://arxiv.org/abs/1412.6980v8).
It is a variant of Adam based on the infinity norm.
}
\note{
To enable compatibility with the ranges of the learning rates
of the other optimizers, the learning rate \code{learning_rate}
is internally mapped to \code{2 * learning_rate}. That is,
a learning rat of 0.001 will be mapped to 0.002 (which is the default.)
}
\seealso{
Other optimizers: 
\code{\link{optimizer_adadelta}()},
\code{\link{optimizer_adagrad}()},
\code{\link{optimizer_adam}()},
\code{\link{optimizer_nadam}()},
\code{\link{optimizer_rmsprop}()},
\code{\link{optimizer_sgd}()}
}
\concept{optimizers}
