% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasCensus.R
\name{evalParamCensus}
\alias{evalParamCensus}
\title{evaluate hyperparameter config on census data}
\usage{
evalParamCensus(
  runNr = "00",
  model = "dl",
  k = 30,
  directory = "data",
  target = "age",
  cachedir = "oml.cache",
  task.type = "classif",
  nobs = 10000,
  nfactors = "high",
  nnumericals = "high",
  cardinality = "high",
  prop = 2/3,
  verbosity = 0
)
}
\arguments{
\item{runNr}{run number (character)}

\item{model}{ml/dl model (character)}

\item{k}{number of repeats (integer)}

\item{directory}{location of the (non-default, e.g., tuned) parameter file}

\item{target}{"age" or "income_class"}

\item{cachedir}{cache dir}

\item{task.type}{task type: "classif" or "regression"}

\item{nobs}{number of observations}

\item{nfactors}{factors, e.g., "high"}

\item{nnumericals}{numericals}

\item{cardinality}{cardinality}

\item{prop}{proportion. Default: \code{2/3}}

\item{verbosity}{verbosity level (0 or 1)}
}
\description{
evaluate hyperparameter config on census data
}
\examples{
\dontrun{
modelList <- list("dl", "cvglmnet",  "kknn", "ranger", "rpart" , "svm", "xgboost")
runNr <- list("Default", "00")
directory <- "data"
for (model in modelList){
for (run in runNr){
score <- evalParamCensus(model = model,
                     runNr = run,
                     prop=2/3,
                     k=2)
fileName <- paste0(directory, "/", model, run, "Evaluation.RData")
save(score, file = fileName)
}}
}
}
