% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimLagp.R
\name{plgpEI}
\alias{plgpEI}
\title{Expected improvement (Gramacy)}
\usage{
plgpEI(gpi, x, fmin, pred = predGPsep)
}
\arguments{
\item{gpi}{Gaussian process C-side object}

\item{x}{matrix of points to calculate EI}

\item{fmin}{best function value (y) so far}

\item{pred}{prediction model. Default: \code{predGPsep}}
}
\value{
ei expected improvement
}
\description{
Expected improvement (Gramacy)
}
\examples{

library(laGP)
library(plgp)

ninit <- 12
dim <- 2
X <- designLHD(,rep(0,dim), rep(1,dim), control=list(size=ninit))
y <- funGoldsteinPrice(X)
m <- which.min(y)
ymin <- y[m]
start <- matrix(X[m,], nrow =1)

## 1. Build SPOT BO Model
m1 <- buildBO(x = X, y = y, control = list(target="ei"))
yy <- predict(object = m1, newdata = start)
ei1 <- matrix(yy$ei, ncol = 1)
## Show mue and s
mue <- matrix(yy$y, ncol = 1)
s2 <- matrix(yy$s, ncol = 1)

## 2. Build laGP model
gpi <- newGPsep(X, y, d=0.1, g=1e-8, dK=TRUE)
da <- darg(list(mle=TRUE, max=0.5), designLHD(,rep(0,dim), rep(1,dim), control=list(size=1000)))
mleGPsep(gpi, param="d", tmin=da$min, tmax=da$max, ab=da$ab)
ei2 <- plgpEI(gpi=gpi, x=start, fmin=ymin)
deleteGPsep(gpi)

}
