% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicateHandling.R
\name{duplicateAndReplicateHandling}
\alias{duplicateAndReplicateHandling}
\title{duplicateAndReplicateHandling}
\usage{
duplicateAndReplicateHandling(xnew, x, lower, upper, control)
}
\arguments{
\item{xnew}{matrix of new candidate solution(s), one row for each solution.}

\item{x}{matrix of evaluated solutions.}

\item{lower}{vector for lower boundary of decision space}

\item{upper}{vector for upper boundary of decision space}

\item{control}{list of controls}
}
\value{
matrix \code{xnew}, with additional replicates for non-duplicates,
or duplicates replaced by random solutions.
}
\description{
Handle Duplicates and Replicates
}
\details{
This function deals with duplicates, that is, when a candidate solution (\code{xnew})
has already been evaluated (that is, \code{xnew} is element of \code{x}).
If \code{control$noise} is \code{TRUE} (objective is noisy), duplicates are allowed.
In that case, this function only makes sure that such duplicates
do not receive additional replications (i.e., the duplicate is evaluated only once).
If the objective is not noisy, duplicates are replaced by randomly created solution
and a warning is given.
}
\keyword{internal}
