% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimLBFGSB.R
\name{optimLBFGSB}
\alias{optimLBFGSB}
\title{Minimization by L-BFGS-B}
\usage{
optimLBFGSB(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{optional matrix of points. Only first point (row) is used as startpoint.}

\item{fun}{objective function, which receives a matrix x and returns observations y}

\item{lower}{boundary of the search space}

\item{upper}{boundary of the search space}

\item{control}{list of control parameters
\describe{
  \item{\code{funEvals}}{Budget, number of function evaluations allowed. Default is 100.}
}
All other \code{control} parameters accepted by the \code{optim} function can be used, too, and are passed to \code{optim}.}

\item{...}{passed to \code{fun}}
}
\value{
list, with elements
\describe{
  \item{\code{x}}{NA, not used}
  \item{\code{y}}{NA, not used}
  \item{\code{xbest}}{best solution}
  \item{\code{ybest}}{best observation}
  \item{\code{count}}{number of evaluations of \code{fun} 
       (estimated from the more complicated \code{"counts"} variable returned by \code{optim})}
  \item{\code{message}}{termination message returned by \code{optim}}
}
}
\description{
For minimization, this function uses the \code{"L-BFGS-B"} method from the \code{optim} function, 
which is part of the code{stats} package. It is basically a wrapper, to enable L-BFGS-B for usage
in SPOT.
}
\examples{
res <- optimLBFGSB(,fun = funSphere,lower = c(-10,-20),upper=c(20,8))
res$ybest
}
