% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotModelSelection.R
\name{spotSelectionCriteria}
\alias{spotSelectionAdjustedRsq}
\alias{spotSelectionAic}
\alias{spotSelectionCriteria}
\alias{spotSelectionMae}
\alias{spotSelectionMse}
\alias{spotSelectionRmse}
\alias{spotSelectionRsq}
\alias{spotSelectionSae}
\alias{spotSelectionScaledMse}
\alias{spotSelectionScaledRmse}
\alias{spotSelectionScaledSse}
\alias{spotSelectionSse}
\title{Model selection and error estimation}
\usage{
spotSelectionRsq(yi,fi)
spotSelectionAdjustedRsq(yi,fi,p)
spotSelectionAic(yi,fi,p)
spotSelectionSse(yi,fi)
spotSelectionSae(yi,fi)
spotSelectionMse(yi,fi)
spotSelectionMae(yi,fi)
spotSelectionRmse(yi,fi)
spotSelectionScaledSse(yi,fi)
spotSelectionScaledMse(yi,fi)
spotSelectionScaledRmse(yi,fi);
}
\arguments{
\item{yi}{sampled values vector}

\item{fi}{predicted values vector}

\item{p}{complexity measure or number of regressors}
}
\value{
a scalar value is returned
}
\description{
This is a number of functions for model selection and error estimation: \cr
rsq: R-Squared, can be adjusted with a complexity measure \cr
sse: Sum of Squared Errors \cr
sae: Sum of Absolute Errors \cr
mse: Mean Squared Errors \cr
rmse: Root Mean Squared Errors \cr
aic: Akaike Information Criterion, with bias adjustment for small sample sizes \cr
scaled: this refers to an approach that scales the data before error calculation, see Keijzer (2004).
}
\references{
- Maarten Keijzer. 2004. Scaled Symbolic Regression. Genetic Programming and Evolvable Machines 5 (3): 259-269. \cr
-  Hirotugu Akaike. 1974. A new look at the statistical model identification. IEEE Transactions on Automatic Control 19 (6): 716-723.
}

