% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_irreversible_municipality_mutations.R
\name{get_irreversible_municipality_mutations}
\alias{get_irreversible_municipality_mutations}
\title{Get irreversible municipality mutations}
\usage{
get_irreversible_municipality_mutations(mutations)
}
\arguments{
\item{mutations}{A tibble with municipality mutations (as created by
\code{\link{import_CH_municipality_inventory}})}
}
\value{
A tibble with all the instances of irreversibe mutations. The
  irreversibility cause is part of the output.
}
\description{
This function detects irreversible mutations.
}
\details{
Irreversible mutations are defined as mutations during which territories are
split up. There are different types of irreversible mutations drawn from the
below cited document. In contrast, normal mutations signify a simple
merging of territory which accounts for most of the mutations in Switzerland
since 1960 whereas irreversible mutations occurred only rarely. The aim of
this function is to filter for these irreversible mutations. These can then
be treated separatly.

Definitions for different types of territory split ups are based on:
Erläuterungen und Anwendungen - Historisierte Gemeindeverzeichnis der Schweiz
(2017).
}
\examples{

  mutations <- structure(list(hist_id = c(11320L, 13668L, 13669L),
 district_hist_id = c(10024L, 10024L, 10024L),
 kanton_abbr = c("AG", "AG", "AG"),
 bfs_nr = c(4061L, 4061L, 4084L), 
 name = c("Arni-Islisberg", "Arni (AG)", "Islisberg"), 
 admission_nr = c(1000L, 1481L, 1481L), 
 admission_mode = c(20L, 21L, 21L), 
 admission_date = structure(c(-3653, 4748,  4748),
 class = c("Date")), 
 abolition_nr = c(1481L, NA, NA), 
 abolition_mode = c(29L, NA, NA), 
 abolition_date = structure(c(4747, NA, NA),
 class = c("Date")), 
 change_date = structure(c(4747, 4748, 4748),
 class = c("Date"))), 
 row.names = c(NA, -3L), class = c("tbl_df", "tbl", "data.frame"))
   
irreversible_mutations <- get_irreversible_municipality_mutations(mutations)

}
