% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMME_predict.R
\name{predict.SMME}
\alias{predict.SMME}
\alias{SMME_predict}
\alias{SMME.predict}
\title{Make Prediction From a SMME Object}
\usage{
\method{predict}{SMME}(object, x = NULL, X = NULL, ...)
}
\arguments{
\item{object}{An object of class SMME, produced with \code{softmaximin} with
\eqn{m_\zeta} fitted models for each value of \code{zeta}.}

\item{x}{a matrix of size \eqn{n' \times p} with \eqn{n'} is the number of new data points.}

\item{X}{a list containing the data matrices each of size \eqn{n'_{i} \times p_i},
where \eqn{n'_{i}} is the number of new data points in  the \eqn{i}th dimension.}

\item{...}{ignored}
}
\value{
A list of length \code{length(zeta)}.
If new covariate data is supplied as an \eqn{n' \times p} matrix \code{x}
each item in the list is an \eqn{n'\times m_\zeta} matrix with the linear
predictors computed for each model. If new covariate data is supplied as a
list of matrices each of size \eqn{n'_{i} \times p_i},  each item is an array
of size \eqn{n'_1 \times \cdots \times n'_d \times m_\zeta},
\eqn{d\in \{1,2,3\}}, with the linear predictors computed for each model.
}
\description{
Given new covariate data this function computes the linear predictors
based on the estimated model coefficients in an object produced by the function
\code{softmaximin}. Note that the data can be supplied in two different
formats: i) as a \eqn{n' \times p} matrix (\eqn{p} is the number of model
coefficients and \eqn{n'} is the number of new data points) or ii) as a list
of two or three Kronecker component matrices each of size \eqn{n_i' \times p_i, i = 1, 2, 3}
(\eqn{n_i'} is the number of new marginal data points in the \eqn{i}th dimension).
}
\examples{

##size of example
n1 <- 65; n2 <- 26; n3 <- 13; p1 <- 13; p2 <- 5; p3 <- 4

##marginal design matrices (Kronecker components)
X1 <- matrix(rnorm(n1 * p1, 0, 0.5), n1, p1)
X2 <- matrix(rnorm(n2 * p2, 0, 0.5), n2, p2)
X3 <- matrix(rnorm(n3 * p3, 0, 0.5), n3, p3)
X <- list(X1, X2, X3)

component <- rbinom(p1 * p2 * p3, 1, 0.1)
Beta1 <- array(rnorm(p1 * p2 * p3, 0, 0.1) + component, c(p1 , p2, p3))
Beta2 <- array(rnorm(p1 * p2 * p3, 0, 0.1) + component, c(p1 , p2, p3))
mu1 <- RH(X3, RH(X2, RH(X1, Beta1)))
mu2 <- RH(X3, RH(X2, RH(X1, Beta2)))
Y1 <- array(rnorm(n1 * n2 * n3, mu1), dim = c(n1, n2, n3))
Y2 <- array(rnorm(n1 * n2 * n3, mu2), dim = c(n1, n2, n3))

Y <- array(NA, c(dim(Y1), 2))
Y[,,, 1] <- Y1; Y[,,, 2] <- Y2;

fit <- softmaximin(X, Y, zeta = c(1, 10), penalty = "lasso", alg = "npg")

##new data in matrix form
x <- matrix(rnorm(2 * p1 * p2 * p3), nrow = 2)
yhat <- predict(fit, x = x)

##new data in tensor component form
X1 <- matrix(rnorm(2 * p1), nrow = 2)
X2 <- matrix(rnorm(3 * p2), nrow = 3)
X3 <- matrix(rnorm(4 * p3), nrow = 4)
Yhat <- predict(fit, X = list(X1, X2, X3))

}
\author{
Adam Lund
}
