% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vote.R
\name{vote}
\alias{vote}
\alias{vote.selection}
\title{Extract and adjust voting from selection model}
\usage{
vote(object, ...)

\method{vote}{selection}(object, vote_threshold = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{'selection'}.}

\item{...}{This argument is not used and listed for method consistency}

\item{vote_threshold}{A relative voting threshold in percentage. A feature is
considered to be important when it receives votes passing the threshold. Default is 0.8.}
}
\value{
Vector containing the features selected.
}
\description{
This function is a method for \code{'selection'} object from \code{smle_select()}.
It extracts a voting result for \code{'selection'} and can be used to change the voting percentage threshold.
}
\examples{
Data<-Gen_Data(correlation="MA",family = "gaussian")
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
E<-smle_select(fit,vote=TRUE)
plot(E)
vote(E,vote_threshold = 0.8)
}
