% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_Covariance.R
\name{cov.wt.matrix}
\alias{cov.wt.matrix}
\alias{cov.wt.data.frame}
\alias{cov.wt}
\title{Weighted Covariance Matrices}
\usage{
\method{cov.wt}{matrix}(x, wt = NULL, cor = FALSE, center = TRUE, method = "unbiased", ...)

\method{cov.wt}{data.frame}(x, wt = NULL, cor = FALSE, center = TRUE, method = "unbiased", ...)

cov.wt(
  x,
  wt = NULL,
  cor = FALSE,
  center = TRUE,
  method = c("unbiased", "ML"),
  ...
)
}
\arguments{
\item{x}{a matrix or data frame.  As usual, rows are observations and
    columns are variables.}

\item{wt}{a non-negative and non-zero vector of weights for each
    observation.  Its length must equal the number of rows of \code{x}.}

\item{cor}{a logical indicating whether the estimated correlation
    weighted matrix will be returned as well.}

\item{center}{either a logical or a numeric vector specifying the
    centers to be used when computing covariances.  If \code{TRUE}, the
    (weighted) mean of each variable is used, if \code{FALSE}, zero is
    used.  If \code{center} is numeric, its length must equal the number
    of columns of \code{x}.}

\item{method}{string specifying how the result is scaled, see
    \sQuote{Details} below.  Can be abbreviated.}

\item{...}{Arguments passed into other methods}
}
\value{
A list containing the following named components:
  \item{cov}{the estimated (weighted) covariance matrix}
  \item{center}{an estimate for the center (mean) of the data.}
  \item{n.obs}{the number of observations (rows) in \code{x}.}
  \item{wt}{the weights used in the estimation.  Only returned if given
    as an argument.}
  \item{cor}{the estimated correlation matrix.  Only returned if
    \code{cor} is \code{TRUE}.}
}
\description{
Returns a list containing estimates of the weighted covariance matrix
  and the mean of the data, and optionally of the (weighted) correlation
  matrix.
}
\details{
By default, \code{method = "unbiased"},
  The covariance matrix is divided by one minus the sum of squares of
  the weights, so if the weights are the default (\eqn{1/n}) the conventional
  unbiased estimate of the covariance matrix with divisor \eqn{(n - 1)}
  is obtained.
}
\examples{
(xy <- cbind(x = 1:10, y = c(1:3, 8:5, 8:10)))
 w1 <- c(0,0,0,1,1,1,1,1,0,0)
 cov.wt(xy, wt = w1) # i.e. method = "unbiased"
 cov.wt(xy, wt = w1, method = "ML", cor = TRUE)
}
\seealso{
Other Tools: 
\code{\link{auc.numeric}()},
\code{\link{preorder}()},
\code{\link{presort}()}
}
\concept{Tools}
\keyword{internal}
