% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_phiA.R
\name{calc_phiA}
\alias{calc_phiA}
\title{Calculate the loss function of the A-optimal design}
\usage{
calc_phiA(design, theta, FUN, tt, A)
}
\arguments{
\item{design}{The resulted design that contains the design points and the associated weights}

\item{theta}{The parameter value of the model}

\item{FUN}{The function to calculate the derivative of the given model.}

\item{tt}{The level of skewness}

\item{A}{The calculated covariance matrix}
}
\value{
The loss of the model at each design points
}
\description{
Calculate the loss function of the A-optimal design
}
\details{
This function calculates the loss function of the design problem under the A-optimality. The loss function under A-optimality is defined as the trace of the inverse of the Fisher information matrix
}
\examples{
my_design <- data.frame(location = c(0, 180), weight = c(1/2, 1/2))
theta <- c(0.05, 0.5)
peleg <- function(xi, theta){
   deno <- (theta[1] + xi * theta[2])^2
   rbind(-xi/deno, -xi^2/deno)
}
A <- matrix(c(1, 0, 0, 0, 0.2116, 1.3116, 0, 1.3116, 15.462521), byrow = TRUE, ncol = 3)
res <- calc_phiA(my_design, theta, peleg, 0, A)
res

}
