% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSA_multi.R
\name{SSA.multi}
\alias{SSA.multi}
\title{Simultaneous estimation of Michaelis-Menten constant and catalytic constant
using the likelihood function with the stochastic simulation approximation method}
\usage{
SSA.multi(method = T, time, species, enz, subs, MM, catal, tun = 2.4,
  std, nrepeat, jump = 1, burning = 0, catal_m = 1,
  catal_v = 10000, MM_m = 1, MM_v = 10000)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{tun}{tunning constant of MH algorithm (default=2.4)}

\item{std}{standard deviation of proposal distribution (if =0, caclulated by Opt. function)}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{catal_m}{prior mean of gamma prior (default =1)}

\item{catal_v}{prior variance of gamma prior (default =10000)}

\item{MM_m}{prior mean of gamma prior (default =1)}

\item{MM_v}{prior variance of gamma prior (default =10000)}
}
\value{
A n*2 matrix of postrior samples of catalytic constant and MM constant
}
\description{
The function estimates both catalytic constant and Michaelis-Menten constant simultaneously
using single data set with an initial enzyme concentrations and substrate concentration.
The stochastic simulation approximation is utilized for the likelihood function
}
\details{
The function DA.multi generates a set of MCMC simulation samples from
the posterior distribution of catalytic constant and MM constant of enzyme
kinetics model. As the function estimates both two constants the user should
input the enzyme and substrate initial concentration. The prior information
for both two parameters can be given. The function utilizes the Gibbs sampler
to update two parameters iteratively from conditional posterior distribution.
Updating catalytic constant is conducted using conditional gamma distribution.
The posterior samples of MM constant are drawn vis Metropolis-Hasting algorithm
with random walk chain. The turning constant (scale_tun) and standard deviation
of proposal normal distribution (sig) can be set to controlled proper mixing and
acceptance ratio of the parameter from the conditional posterior distribution.
The posterior samples are only stored with fixed interval according to set "jump"
to reduce serial correlation. The initial iterations are removed for convergence.
The “burning” is set the length of initial iterations. The stochastic simulation
approximation method is used for construction of the likelihood.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
Chymotrypsin.low<-SSA.multi(method=TRUE, time=time1,species=species1,enz=4.4e+7
,subs=4.4e+7,MM=1e+9,catal=0.01,tun=2.4,std=8e+7,nrepeat=10000,jump=1,
burning=0,catal_m=1,catal_v=1e+10, MM_m=1e+9,MM_v=1e+18)
}
