% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_combi.R
\name{GP.combi}
\alias{GP.combi}
\title{Simultaneous estimation of Michaelis-Menten constant and catalytic constant using
combined data and the likelihood function with the Gaussian process method}
\usage{
GP.combi(method = T, RAM = F, time1, dat1, time2, dat2, enz, subs, MM,
  catal, nrepeat = 11000, jump = 1, burning = 1000,
  catal_m_v = c(1, 10000), MM_m_v = c(1, 10000), sig, va)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{RAM}{Robust Adaptive MCMC options (default = F)}

\item{time1}{total time of dataset1}

\item{dat1}{observed dataset1 ( trajectory column )}

\item{time2}{total time of dataset2}

\item{dat2}{observed dataset2 ( trajectory column )}

\item{enz}{enzyme concentrate}

\item{subs}{substrate concentrate}

\item{MM}{initial value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of iteration (defuault=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{length of burning period (default =0)}

\item{catal_m_v}{catalytic prior gamma mean, variance(default=c(1,10000))}

\item{MM_m_v}{MM prior gamma mean, variance(default=c(1,10000))}

\item{sig}{variance of bivariate Normal proposal distribution}

\item{va}{variance of data}
}
\value{
A n*2 matrix of postrior samples of catalytic constant and MM constant
}
\description{
The function estimates both catalytic constant and Michaelis-Menten constant
simultaneously using combined data sets with different enzyme concentrations
or substrate concentrations. The Gaussian process is utilized for the
likelihood function.
}
\details{
The function GP.combi generates a set of MCMC simulation samples from the
posterior distribution of catalytic constant and MM constant of enzyme kinetics model.
As the function uses combined data set with different initial concentration of enzyme
or substrate concentration the user should input two values of enzyme and substrate
initial concentration. The prior information for both two parameters can be given.
The function can select Robust Adaptive Metropolis (RAM) algorithm as well as
Metropolis-Hastings algorithm with random walk chain for MCMC procedure. When “RAM”
is assigned T then the function use RAM method and the “sig” is used as initial
variances of normal proposal distribution for catalytic and MM constant. When “RAM”
is F, the function use Metropolis-Hastings algorithm with random walk chain and the
“sig” can be set to controlled proper mixing and acceptance ratio of the parameter
for updating two parameters simultaneously. The “va” is the variance of the Gaussian
process. The posterior samples are only stored with fixed interval according to set
"jump" to reduce serial correlation. The initial iterations are removed for convergence.
The “burning” is set the length of initial iterations. The Gaussian process method
is used for construction of the likelihood
}
\examples{
\dontrun{
data('Chymo_low')
data('Chymo_high')
time1 = max(Chymo_low[,1])*1.01
time2 = max(Chymo_high[,1])*1.01
comb_GPMH=GP.combi(method=TRUE,dat1=Chymo_low[,2],time1=time1,dat2=Chymo_high[,2],time2=time2
                  ,enz=c(4.4e+7,4.4e+9),subs=4.4e+7,MM=4.4e+8,catal=0.05,nrepeat=10000
                  ,jump=1,burning=0,catal_m_v=c(1,1e+10),MM_m_v=c(1e+9,1e+18)
                  ,sig=c(0.005,4.4e+8)^2,va=c(var(Chymo_low[,2]),var(Chymo_high[,2])))

# use RAM algorithm #
comb_GPRAM=GP.combi(method=TRUE,RAM=TRUE,dat1=Chymo_low[,2],time1=time1,dat2=Chymo_high[,2]
                     ,time2=time2,enz=c(4.4e+7,4.4e+9),subs=4.4e+7,MM=4.4e+8,catal=0.05
                     ,nrepeat=10000,jump=1,burning=0,catal_m_v=c(1, 1e+6),MM_m_v=c(1,1e+10)
                     ,sig=c(1,1e+11),va=c(var(Chymo_low[,2]),var(Chymo_high[,2])))
}

}
