% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{incorporators_taxonomy}
\alias{incorporators_taxonomy}
\title{Isotope incorporator list with GTDB taxonomy}
\usage{
incorporators_taxonomy(taxonomy, bootstrapped_AFE_table)
}
\arguments{
\item{taxonomy}{A taxonomy tibble obtained in the markdown. This taxonomy tibble is
typically a concatenated list of archaeal and bacterial taxonomy from GTDB-Tk
Please check GTDB-Tk documentation for running the tool}

\item{bootstrapped_AFE_table}{A data frame indicating bootstrapped atom fraction excess values}
}
\value{
A tibble with two columns, OTU and Taxonomy, with taxonomy of the incorporator MAGs
}
\description{
This function provides a table with MAGs and their corresponding GTDB taxonomy
as an output. This would be useful in identifying the taxa that have incorporation
}
\examples{
data(taxonomy_tibble,df_atomX_boot)

\donttest{

### Making incorporator taxonomy list
incorporator_list = incorporators_taxonomy(taxonomy = taxonomy_tibble,
         bootstrapped_AFE_table = df_atomX_boot)
}

}
