% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{swarm}
\alias{swarm}
\title{Swarm}
\usage{
swarm(x, p = NULL, year = NULL, nVirginQueens = NULL, simParamBee = NULL, ...)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{p}{numeric, proportion of workers that will leave with the swarm colony;
if \code{NULL} then \code{\link{SimParamBee}$swarmP} is used.
If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies}

\item{year}{numeric, year of birth for virgin queens}

\item{nVirginQueens}{integer, the number of virgin queens to be created in the
colony; of these one is randomly selected as the new virgin queen of the
remnant colony. If \code{NULL}, the value from \code{simParamBee$nVirginQueens}
is used}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{p} or \code{nVirginQueens}
when these arguments are functions}
}
\value{
list with two \code{\link{Colony-class}} or \code{\link{MultiColony-class}},
the \code{swarm} and the \code{remnant} (see the description what each colony holds!); both
outputs have the swarm event set to \code{TRUE}
}
\description{
Level 2 function that swarms a Colony or MultiColony object -
  an event where the queen
  leaves with a proportion of workers to create a new colony (the swarm). The
  remnant colony retains the other proportion of workers and all drones, and
  the workers raise virgin queens, of which only one prevails. Location of
  the swarm is the same as for the remnant (for now).
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
(colony <- buildUp(colony, nWorkers = 100))
apiary <- createMultiColony(basePop[3:8], n = 6)
apiary <- cross(apiary, drones = droneGroups[2:7])
apiary <- buildUp(apiary, nWorkers = 100)

# Swarm a colony
tmp <- swarm(colony)
tmp$swarm
tmp$remnant

# Swarm all colonies in the apiary with p = 0.6 (60\% of workers leave)
tmp <- swarm(apiary, p = 0.6)
nWorkers(tmp$swarm)
nWorkers(tmp$remnant)
# Swarm with different proportions
nWorkers(apiary)
tmp <- swarm(apiary, p = c(0.4, 0.6, 0.5, 0.5, 0.34, 0.56))
nWorkers(tmp$swarm)
nWorkers(tmp$remnant)

# Sample colonies from the apiary that will swarm (sample with probability of 0.2)
tmp <- pullColonies(apiary, p = 0.2)
# Swarm only the pulled colonies
(swarm(tmp$pulled, p = 0.6))
}
